/*xxx
* \brief - SIM::wgn - real value white gaussian noise generator
* \author maki
*/

#include "sim\sim_wgn.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

void wgn::set_sigma(double s)
{
  sigma = s;
}

void wgn::set_mean(double m)
{
  mean = m;
}

void wgn::set_output(double yout)
{
  y0 = yout;
}

double wgn::get_sigma(void)
{
  return(sigma);
}

double wgn::get_mean(void)
{
  return(mean);
}

double wgn::get_output(void)
{
  return(y0);
}


vec wgn::generate(const bvec &ce)
{
  vec y;
  int L;

  debug(3) << "wgn::generate() ce = " << ce << endl;

  L = ce.length();
  y.set_size(L);
  for(int i = 0; i < L; i++)
  {
    if(bool(ce[i]))
    {
      y0 = sigma * randn() + mean; //
    }
    y[i] = y0;
  }

  debug(3) << "wgn::generate() y = " << y << endl;
  return (y);
}

} // namespace SIM