/*xxx
* \brief - SIM::wgn_x - complex value white gaussian noise generator
* \author maki
*/

#include "sim\sim_wgn_x.hpp"
#include "sim\_sim_exception.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SIM
{

double wgn_x::normalize = 1.0 / (std::sqrt(2.0));

void wgn_x::set_sigma(double s)
{
  sigma = s;
}

void wgn_x::set_mean(complexd m)
{
  mean = m;
}

void wgn_x::set_output(complexd yout)
{
  y0 = yout;
}

double wgn_x::get_sigma(void)
{
  return(sigma);
}

complexd wgn_x::get_mean(void)
{
  return(mean);
}

complexd wgn_x::get_output(void)
{
  return(y0);
}


cvec wgn_x::generate(const bvec &ce)
{
  cvec y;
  int L;

  debug(3) << "wgn_x::generate() ce = " << ce << endl;

  L = ce.length();
  y.set_size(L);
  for(int i = 0; i < L; i++)
  {
    if(bool(ce[i]))
    {
      y0 = sigma * normalize * (complexd(randn(), randn())) + mean;
    }
    y[i] = y0;
  }

  debug(3) << "wgn_x::generate() y = " << y << endl;
  return (y);
}

} // namespace SIM