/*!
* \file
* \author mk
* \brief - execute test file: tf_sci_fun() defined by TEST_FIR (or else) DEFINE
*
* load and test dll with sci_base interface functions - Abstraction Layer API
* \n sci_create(*p,fir), sci_set(p,par), sci_get(p,par), sci_exec(p,commd), sci_proc(p,ce,x,y)
* \n where: sci_base *p;
*/

#include <iostream>
#include <fstream>
#include <iomanip>

//---- SCI   ------
#include "sci\_sci_api_dll.hpp"


//---- MSVC ------
#include "stdafx.h"
#include <windows.h>
// #include <stdio.h>
// #include <stdlib.h>
// #include <io.h>

// DEBUG_LEVEL is defined by "sci_debug_level.h" IN CURRENT DIRECTORY !
#include "__debug.h"
//---- SCI TESTS SELECTED BY PROJECT DEFINE ------
#include "tf_sci.hpp"


using namespace std;
using namespace itpp;
using namespace SCI;

pf_sci_create   sci_create;
pf_sci_set      sci_set;
pf_sci_get      sci_get;
pf_sci_exec     sci_exec;
pf_sci_gen      sci_gen;
pf_sci_proc     sci_proc;
pf_sci_destroy  sci_destroy;

HINSTANCE      hnd_dll;

int Load_DLL(void)
{
  // Load and get handler
#ifdef _DEBUG
  // hnd_dll= LoadLibrary(TEXT("c_sci_dll_dbg"));
  hnd_dll = LoadLibrary(TEXT("sci_itpp"));
#else
  hnd_dll = LoadLibrary(TEXT("sci_itpp"));
#endif
  if(!hnd_dll)
  {
    cout << "EXE: Error loading DLL\n";
    return (-1);
  }
  // Get Interface Function
  sci_create = (pf_sci_create) GetProcAddress(hnd_dll, "sci_create");
  if(!sci_create)
  {
    cout << "EXE: Unable to get sci_create interface \n";
    return (-1);
  }
  // Get Interface Function
  sci_set = (pf_sci_set) GetProcAddress(hnd_dll, "sci_set");
  if(!sci_set)
  {
    cout << "EXE: Unable to get sci_set interface \n";
    return (-1);
  }
  // Get Interface Function
  sci_get = (pf_sci_get) GetProcAddress(hnd_dll, "sci_get");
  if(!sci_get)
  {
    cout << "EXE: Unable to get sci_get interface \n";
    return (-1);
  }
  // Get Interface Function
  sci_exec = (pf_sci_exec) GetProcAddress(hnd_dll, "sci_exec");
  if(!sci_exec)
  {
    cout << "EXE: Unable to get sci_exec interface \n";
    return (-1);
  }
  // Get Interface Function
  sci_gen = (pf_sci_gen) GetProcAddress(hnd_dll, "sci_gen");
  if(!sci_exec)
  {
    cout << "EXE: Unable to get sci_gen interface \n";
    return (-1);
  }
  // Get Interface Function
  sci_proc = (pf_sci_proc) GetProcAddress(hnd_dll, "sci_proc");
  if(!sci_proc)
  {
    cout << "EXE: Unable to get sci_proc interface \n";
    return (-1);
  }
  // Get Interface Function
  sci_destroy = (pf_sci_destroy) GetProcAddress(hnd_dll, "sci_destroy");
  if(!sci_proc)
  {
    cout << "EXE: Unable to get sci_proc interface \n";
    return (-1);
  }
  return (0);


  return (0);
}

using namespace std;

int main()
{
  int err;

  // get DLL set API
  err = Load_DLL();
  if(err)
  {
    if(!hnd_dll)
      FreeLibrary(hnd_dll);
    cout << "DLL not loaded \n";
    return (-1);
  }
  // test API - use c_sci function defined by TEST_FIR or else in /D DEFINE
  err = tf_sci();
  cout << "c_sci_exe: This is all folks, err= "  << err << endl;
  return(err);
}





