/*!
* \file
* \author mk
* \brief - load and test c_sci_if.dll by exec tf_sci_if_XXX()
*/
#include <iostream>
#include <fstream>
#include <iomanip>
#include "stdafx.h"
#include <windows.h>

//---- SCI   ------
#include "sci\_sci_if_dll.h"



//---- SCI TESTS SELECTED BY PROJECT DEFINE ------
#include "tf_sci.hpp"
// DEBUG_LEVEL is defined by "sci_debug_level.h" IN CURRENT DIRECTORY !
#include "__debug.h"

pf_sci_if_copy_var      sci_if_copy_var;
pf_sci_if_delete_var    sci_if_delete_var;
pf_sci_if_create        sci_if_create;
pf_sci_if_set	        sci_if_set;
pf_sci_if_get	        sci_if_get;
pf_sci_if_exec	        sci_if_exec;
pf_sci_if_gen	        sci_if_gen;
pf_sci_if_proc	        sci_if_proc;
pf_sci_if_destroy	    sci_if_destroy;

HINSTANCE      hnd_dll;

// DEBUG_LEVEL is defined by in this folder!
#include "__debug.h"


int Load_DLL(void)
{
  // Load and get handler
  hnd_dll = LoadLibrary(TEXT("sci_if"));
  if(!hnd_dll)
  {
    debug_1("EXE: Error loading DLL\n");
    return (-1);
  }

  // Get Interface Functions
  sci_if_copy_var = (pf_sci_if_copy_var) GetProcAddress(hnd_dll, "sci_if_copy_var");
  if(!sci_if_copy_var)
  {
    debug_1("EXE: Unable to get <sci_if_copy_var> interface \n");
    return (-1);
  }

  sci_if_delete_var = (pf_sci_if_delete_var) GetProcAddress(hnd_dll, "sci_if_delete_var");
  if(!sci_if_delete_var)
  {
    debug_1("EXE: Unable to get <sci_if_delete_var> interface \n");
    return (-1);
  }

  sci_if_create = (pf_sci_if_create) GetProcAddress(hnd_dll, "sci_if_create");
  if(!sci_if_create)
  {
    debug_1("EXE: Unable to get < sci_if_create > interface \n");
    return (-1);
  }

  sci_if_set = (pf_sci_if_set) GetProcAddress(hnd_dll, "sci_if_set");
  if(!sci_if_set)
  {
    debug_1("EXE: Unable to get < sci_if_set > interface \n");
    return (-1);
  }

  sci_if_get = (pf_sci_if_get) GetProcAddress(hnd_dll, "sci_if_get");
  if(!sci_if_get)
  {
    debug_1("EXE: Unable to get < sci_if_get > interface \n");
    return (-1);
  }

  sci_if_exec = (pf_sci_if_exec) GetProcAddress(hnd_dll, "sci_if_exec");
  if(!sci_if_exec)
  {
    debug_1("EXE: Unable to get < sci_if_exec > interface \n");
    return (-1);
  }

  sci_if_gen = (pf_sci_if_gen) GetProcAddress(hnd_dll, "sci_if_gen");
  if(!sci_if_gen)
  {
    debug_1("EXE: Unable to get < sci_if_gen > interface \n");
    return (-1);
  }

  sci_if_proc = (pf_sci_if_proc) GetProcAddress(hnd_dll, "sci_if_proc");
  if(!sci_if_proc)
  {
    debug_1("EXE: Unable to get < sci_if_proc > interface \n");
    return (-1);
  }

  sci_if_destroy = (pf_sci_if_destroy) GetProcAddress(hnd_dll, "sci_if_destroy");
  if(!sci_if_destroy)
  {
    debug_1("EXE: Unable to get < sci_if_destroy > interface \n");
    return (-1);
  }

  return (0);
}


using namespace std;
int main()
{
  int err;

  //----------------------------------------
  // get API
  //----------------------------------------

  err = Load_DLL();
  if(err)
  {
    if(!hnd_dll)
      FreeLibrary(hnd_dll);
    debug_1("DLL not loaded \n");
    return (-1);
  }
  else
  {
    // test API - use c_sci function defined by TEST_FIR or else in /D DEFINE
    err = tf_sci();
    cout << "sci_if_tf: This is all folks, err= "  << err << endl;

  }
  return(err);
}


