/*xxx
* \brief - definition of conversion functions for simulated scipy variables
* \author maki
*/

#include "sci\_sci_if_emu_var_struct.hpp"
#include "sci\_sci_if_op.hpp"
#include "sci\_sci_exception.hpp"
#include "sci\_sci_types.h"

#include "_sci_if_var_struct.h"

using namespace itpp;
using namespace std;


namespace SCI
{
/// \cond EMU_DOC

void delete_emu_var_struct_data(struct var_struct *p_v_s)
{

  switch(p_v_s->sci_type)
  {
    case SCI_TYPE_DOUBLE:
      try
      {
        delete p_v_s->p_external.p_double;
      }
      catch(...)
      {
        throw sci_exception("delete_emu_var_struct_data() DOUBLE exception ");
      }
      break;
    case SCI_TYPE_VEC:
    case SCI_TYPE_MAT:
      try
      {
        delete[] p_v_s->p_external.p_double;
      }
      catch(...)
      {
        throw sci_exception("delete_emu_var_struct_data() VEC,MAT exception ");
      }
      break;
    case SCI_TYPE_COMPLEX:
      try
      {
        delete p_v_s->p_external.p_complex; // sim create array [] for cvec or cmat
      }
      catch(...)
      {
        throw sci_exception("delete_emu_var_struct_data() COMPLEX exception ");
      }
      break;
    case SCI_TYPE_CVEC:
    case SCI_TYPE_CMAT:
      try
      {
        delete[] p_v_s->p_external.p_complex; // sim create array [] for cvec or cmat
      }
      catch(...)
      {
        throw sci_exception("delete_emu_var_struct_data() CVEC,CMAT exception ");
      }
      break;
    case SCI_TYPE_INT:
      try
      {
        delete p_v_s->p_external.p_int;
      }
      catch(...)
      {
        throw sci_exception("delete_emu_var_struct_data() INT exception ");
      }
      break;
    case SCI_TYPE_IVEC:
    case SCI_TYPE_IMAT:
      try
      {
        delete[] p_v_s->p_external.p_int;
      }
      catch(...)
      {
        throw sci_exception("delete_emu_var_struct_data() IVEC,IMAT exception ");
      }
      break;
    case SCI_TYPE_BOOL:
      try
      {
        delete p_v_s->p_external.p_bool;
      }
      catch(...)
      {
        throw sci_exception("delete_emu_var_struct_data() BOOL exception ");
      }
      break;
    case SCI_TYPE_BVEC:
    case SCI_TYPE_BMAT:
      try
      {
        delete[] p_v_s->p_external.p_bool;
      }
      catch(...)
      {
        throw sci_exception("delete_emu_var_struct_data() BVEC,BMAT exception ");
      }
      break;
    default:
      throw sci_exception("delete_emu_var_struct_data() unknown sci_type exception ");
      break;
  }

}

void emu_sci_if_malloc(struct var_struct *p_v_s)
{
  switch(p_v_s->sci_type)
  {
    case SCI_TYPE_DOUBLE:
      try
      {
        p_v_s->p_external.p_double = new(double);
      }
      catch(...)
      {
        throw sci_exception("emu_sci_if_malloc() DOUBLE exception ");
      }
      break;

    case SCI_TYPE_VEC:
    case SCI_TYPE_MAT:
      try
      {
        p_v_s->p_external.p_double = new(double[(p_v_s->rows) * (p_v_s->cols)]);
      }
      catch(...)
      {
        throw sci_exception("emu_sci_if_malloc() VEC,MAT exception ");
      }
      break;

    case SCI_TYPE_COMPLEX:
      try
      {
        p_v_s->p_external.p_complex = new(std::complex<double>);
      }
      catch(...)
      {
        throw sci_exception("emu_sci_if_malloc() COMPLEX exception ");
      }
      break;

    case SCI_TYPE_CVEC:
    case SCI_TYPE_CMAT:
      try
      {
        p_v_s->p_external.p_complex = new(std::complex<double>[(p_v_s->rows) * (p_v_s->cols)]);
      }
      catch(...)
      {
        throw sci_exception("emu_sci_if_malloc() CVEC,CMAT exception ");
      }
      break;

    case SCI_TYPE_INT:
      try
      {
        p_v_s->p_external.p_int = new(int);
      }
      catch(...)
      {
        throw sci_exception("emu_sci_if_malloc() INT exception ");
      }
      break;

    case SCI_TYPE_IVEC:
    case SCI_TYPE_IMAT:
      try
      {
        p_v_s->p_external.p_int = new(int[(p_v_s->rows) * (p_v_s->cols)]);
      }
      catch(...)
      {
        throw sci_exception("emu_sci_if_malloc() IVEC,IMAT exception ");
      }
      break;

    case SCI_TYPE_BOOL:
      try
      {
        p_v_s->p_external.p_bool = new(bool);
      }
      catch(...)
      {
        throw sci_exception("emu_sci_if_malloc() BOOL exception ");
      }
      break;

    case SCI_TYPE_BVEC:
    case SCI_TYPE_BMAT:
      try
      {
        p_v_s->p_external.p_bool = new(bool[(p_v_s->rows) * (p_v_s->cols)]);
      }
      catch(...)
      {
        throw sci_exception("emu_sci_if_malloc() BVEC,BMAT exception ");
      }
      break;
    default:
      throw sci_exception("delete_emu_var_struct_data unknown sci_type exception ");
      break;
  }

}

/// \endcond

}
