//! QAM_MOD +  QAM_DEM 

clear;
clearglobal;
clc;
lines(0);
path=get_absolute_file_path("app01.sce")
chdir(path);
pwd
//---------------------------
$API="..\..\lib\sci_api1.sci";
dbg=0;
exec($API);  
//---------------------------
$FUNC="..\..\lib\sci_func1.sci";
exec($FUNC);  
//---------------------------
$FUN_SPEC="..\common\sci_spect1.sci";
exec($FUN_SPEC);  

// Fig 1,2,4
xdel(winsid());
exec("..\common\sci_fig4_1.sci");

// GetConfig 
exec("..\common\sci_tk_getcfg_v1.sci");
exec(".\sci_app01_cfg.sci");

// simulation setup
conf_filename=csim_tkgetconfig(".\conf\conf_def.cfg",".\conf")
[sim_conf,err]=loadconfig(conf_filename);
disp(sim_conf);

// GP variables
NULL=0;

//---------------------------
// signal source QAM/PSK modulator
MOD=sim_conf.MOD;
// signal source - SIZE QAM/PSK modulator
M=sim_conf.M;
// C_NdB for wgn_x
C_N_set=sim_conf.C_N_set
// MAV for RMS estimator
RMS_MAV=sim_conf.RMS_MAV;
// size of PRBS generator
PRBS = sim_conf.PRBS;
// size of graphic circular buff for IQ
N_GCB = sim_conf.N_GCB;
// size of FFT for spectral analysis
N_FFT = sim_conf.N_FFT;
// frequency of PM 
FPM=sim_conf.FPM;
// PMdB=[min max initial]
PM_set=sim_conf.PM_set

// initial state of 'noise' flags
// PM_flag 0 == OFF
PM_flag = 0;
// no noise
AWGN_flag = 0;

// QAM modulator
if MOD=="PSK"
  p_mod1 = SCI_CREATE(SCI_PSK_MOD);
  SCI_SET(p_mod1, SCI_SIZE, M);
  // to modulate demodulator output
  p_mod2 = SCI_CREATE(SCI_PSK_MOD);
  SCI_SET(p_mod2, SCI_SIZE, M);
  // demodulator
  p_dem1 = SCI_CREATE(SCI_PSK_DEM);
  SCI_SET(p_dem1, SCI_SIZE, M);
else
  p_mod1 = SCI_CREATE(SCI_QAM_MOD);
  SCI_SET(p_mod1, SCI_SIZE, M);
  // to modulate demodulator output
  p_mod2 = SCI_CREATE(SCI_QAM_MOD);
  SCI_SET(p_mod2, SCI_SIZE, M);
  // QAM demodulator
  p_dem1 = SCI_CREATE(SCI_QAM_DEM);
  SCI_SET(p_dem1, SCI_SIZE, M);
end

SCI_GET(p_mod1, SCI_SIZE)
SCI_GET(p_mod2, SCI_SIZE)
SCI_GET(p_dem1, SCI_SIZE)

// pre-calculated RMS values - using variance of discrete process
// see dsp/carrier/carrier1.sce
if MOD=="QAM"
  select M
    case 4 then C_rms=0.7071068; 
    case 16 then C_rms=0.7905694;
    case 64 then C_rms=0.8100926; 
    case 256 then C_rms=0.8149003;
    else  
      print('\n UNKNOWN QAM - ABORT !!! \n');
      exit;
    end    
else
  select M
    case 2 then C_rms=0.5;
    case 4 then C_rms=0.7071068;
    case 8 then C_rms=0.7071068;
    case 16 then C_rms=0.7071068;
    case 32 then C_rms=0.7071068;
    else  
      print('\n UNKNOWN PSK - ABORT !!! \n');
      exit;
    end                
end    

// Graphics CIRCBUFF_X for IQ data
p_cb_x1 = SCI_CREATE(SCI_CIRCBUFF_X);
SCI_SET(p_cb_x1, SCI_SIZE, N_GCB);
p_cb_x2 = SCI_CREATE(SCI_CIRCBUFF_X);
SCI_SET(p_cb_x2, SCI_SIZE, N_GCB);
// FFT CIRCBUFF_X  
p_fft_x1 = SCI_CREATE(SCI_CIRCBUFF_X);
SCI_SET(p_fft_x1, SCI_SIZE, N_FFT);
p_fft_x2 = SCI_CREATE(SCI_CIRCBUFF_X);
SCI_SET(p_fft_x2, SCI_SIZE, N_FFT);
p_fft_x3 = SCI_CREATE(SCI_CIRCBUFF_X);
SCI_SET(p_fft_x3, SCI_SIZE, N_FFT);

// word length    
W = ceil(log2(M));
// prbs source
p_prbs1 = SCI_CREATE(SCI_LFSR);
SCI_SET(p_prbs1, SCI_PRBS, PRBS);
SCI_SET(p_prbs1, SCI_SYMBOL_SIZE, W);
// bin to int 
p_b2i1=SCI_CREATE(SCI_BIN2INT);
SCI_SET(p_b2i1, SCI_SYMBOL_SIZE, W);
p_i2b1=SCI_CREATE(SCI_INT2BIN);
SCI_SET(p_i2b1, SCI_SYMBOL_SIZE, W);

// RMS to measure modulated carrier
p_rms_x1 = SCI_CREATE(SCI_RMS_X);
SCI_SET(p_rms_x1,SCI_SIZE, RMS_MAV);
// RMS to measure noise
p_rms_x2 = SCI_CREATE(SCI_RMS_X);
SCI_SET(p_rms_x2,SCI_SIZE, RMS_MAV);
// RMS to measure demodulated carrier
p_rms_x3 = SCI_CREATE(SCI_RMS_X);
SCI_SET(p_rms_x3,SCI_SIZE, RMS_MAV);
// RMS to measure constellation noise
p_rms_x4 = SCI_CREATE(SCI_RMS_X);
SCI_SET(p_rms_x4,SCI_SIZE, RMS_MAV);
// WGN_X - complex noise generator
p_wgn_x1 = SCI_CREATE(SCI_WGN_X);

// bert
p_bert1 = SCI_CREATE(SCI_BERT);
SCI_SET(p_bert1, SCI_PRBS, PRBS);
// bert correlator length 40 bits
BERT_LEN = 40;
SCI_SET(p_bert1, SCI_LENGTH, BERT_LEN);
// symbol length must be set after BERT_LEN
SCI_SET(p_bert1, SCI_SYMBOL_SIZE, W);
// ERR < T0 - for lock into BERT_FSM_SYNC state
// ERR < T1 - for staying locked in BERT_FSM_SYNC
// ERR < T2 - for staying in BERT_FSM_nSYNC - not error counting - but tracking
// T= [T0, T1, T2] - T0/LENGTH = BER < 4/40 (less than 1.0E-1); 
BERT_TH = [4 8 10]; 
SCI_SET(p_bert1, SCI_THRESHOLD, BERT_TH);
// set inital state
// SCI_SET(p_bert1, SCI_FSM, BERT_FSM_RELOAD);
SCI_EXEC(p_bert1, SCI_START);

// phase for sine PM
p_nco1 = SCI_CREATE(SCI_NCO);
// sine PM
p_ejp1 = SCI_CREATE(SCI_EJP);
// carrier modulation
p_ejp2 = SCI_CREATE(SCI_EJP);
// carrier modulator
p_mix_x1 = SCI_CREATE(SCI_MIX_X);


// structs for FFT data 
s_sp1 = struct('p_fft_x',p_fft_x1, 'Nfft', N_FFT, 'Navg', 0, 'sig', zeros(1:N_FFT),...
'wsig', zeros(1:N_FFT), 'spect', %eps*ones(1:N_FFT), 'avg_spect', %eps*ones(1:N_FFT),...
'ff',zeros(1:N_FFT),'minff', -0.5, 'maxff', +0.5);
s_sp2 = struct('p_fft_x',p_fft_x2, 'Nfft', N_FFT, 'Navg', 0, 'sig', zeros(1:N_FFT),...
'wsig', zeros(1:N_FFT), 'spect', %eps*ones(1:N_FFT), 'avg_spect', %eps*ones(1:N_FFT),...
'ff',zeros(1:N_FFT), 'minff', -0.5, 'maxff', +0.5 );
s_sp3 = struct('p_fft_x',p_fft_x3, 'Nfft', N_FFT, 'Navg', 0, 'sig', zeros(1:N_FFT),...
'wsig', zeros(1:N_FFT), 'spect', %eps*ones(1:N_FFT), 'avg_spect', %eps*ones(1:N_FFT),...
'ff',zeros(1:N_FFT), 'minff', -0.5, 'maxff', +0.5);

// tk and global access variables
exec("sci_tk_app01_v1.sci");

N_opt1 = TCL_GetVar('Nopt');
N=floor(sscanf(N_opt1,"%d"));

// set delay timer unit
// realtimeinit(0.25);        // timepass unit
realtimeinit(1);              // timepass unit
realtime(0);                  // first call sets init time
time_up = 0;
avg = 0;

printf("Current time=\n");
printf("%d",time_up);

// variables must exist to be set-up properly
button_state1=TCL_GetVar('button_state')
button_state2=button_state1;
RMS1 = 0.0; RMS2 = 0.0; RMS3 = 0.0; RMS4 = 0.0;
ber=[0, 0]; BER=[0,0];
BERT_LOCK_FLAG = %F;
BERT_CLEAR_FLAG = %F;
while (1==1)

  TCL_EvalStr('set h [winfo exists .app1]');
  if TCL_GetVar("h")=='0' then break, end
  Update_TCLTK();

  if ( BERT_CLEAR_FLAG ) then
    SCI_EXEC(p_bert1, SCI_CLEAR);
    printf(" BERT_CLEARED\n");
    BERT_CLEAR_FLAG = %F;
  end    

  if (button_state1=='state_RUN') then
    ce = (ones(N,1) == 1);
    n_ce = (ones(N,1) == 0);
    // C_N=20*log(C_rms/N_rms)
    N_rms = C_rms/ 10^(C_N/20);
    SCI_SET(p_wgn_x1, SCI_SIGMA, N_rms);
    // AWGN noise 
    if ( AWGN_flag )
      Niq = SCI_GEN(p_wgn_x1, ce);
    else
      Niq = zeros(N,1)+%i*zeros(N,1);
    end

    // PM
    // phase of PM modulation
    cy_phpm = SCI_PROC(p_nco1, ce, FPM*ones(N,1));
    // phase split
    phpm = cy_phpm(:,2);
    // PM phase modulation
    cpm=SCI_PROC(p_ejp1, ce, phpm);
    // PMdB = 20log(deltaP/2) 
    if (PM_flag)
      APM = 2.0/(10^(PM/20)*(2.0 *%pi));
      pm = real(cpm)*APM;
    else
      pm = zeros(N,1);
    end
    // Carrier - PM only
    Cmod=SCI_PROC(p_ejp2, ce, pm);

    // signal 
    Cbin = SCI_GEN(p_prbs1, ce);
    Cint = SCI_PROC(p_b2i1, ce, Cbin);
    Ciq = SCI_PROC(p_mod1, ce, Cint);
    // PM Modulation
    Cpm = SCI_PROC(p_mix_x1, ce, [Ciq,Cmod]);
    // signal + PM+ noise
    C = Cpm + Niq;

    // demodulate C 
    Sint = SCI_PROC(p_dem1, ce, C);
    Siq = SCI_PROC(p_mod2, ce, Sint);

    // measure signal
    Ciq_rms = SCI_PROC(p_rms_x1, ce, Ciq);
    RMS1= mean(Ciq_rms);
    // measure noise
    Niq_rms = SCI_PROC(p_rms_x2, ce, Niq);
    RMS2= mean(Niq_rms);
    // measure signal
    Siq_rms = SCI_PROC(p_rms_x3, ce, Siq);
    RMS3 = mean(Siq_rms);       
    // constelation error
    Eiq = C - Siq;
    Eiq_rms = SCI_PROC(p_rms_x4, ce, Eiq);
    RMS4 = mean(Eiq_rms);       
    // int to bin
    Sbin = SCI_PROC(p_i2b1, ce, Sint);
    // input data to BERT - observe state
    bert_state = double(SCI_PROC(p_bert1, ce, Sbin));
    // lock if state is not lower than [BERT_FSM_SYNC, BERT_FSM_nSYNC] 
    BERT_LOCK_FLAG = and( (bert_state >= BERT_FSM_nSYNC));
    if (~ BERT_LOCK_FLAG) then
      printf(" BERT_UNLOCK\n");
    end

    // instantaneous  [bit_e,bit_cnt]
    ber = SCI_GET(p_bert1, SCI_CNT);
    // accumulated [BIT_ERR, BIT_CNT]
    BER = SCI_GET(p_bert1, SCI_ACC_CNT);
     
    // put data into Graphics circbuff
    SCI_SET(p_cb_x1, SCI_VEC, C);
    SCI_SET(p_cb_x2, SCI_VEC, Siq);        
      
    // spectrum analysis - constant parameters
    // avg is reset when parameters are changed
    if (avg == 0)           
      select fftwintype
        case "rect" then winfft=window('re',Nfft);    // rectangular
        case "tria" then winfft=window('tr',Nfft);    // triangular
        case "hamm" then winfft=window('hm',Nfft);    // Hamming window
        case "hann" then winfft=window('hn',Nfft);     // Hamming window
        case "kais" then winfft=window('kr',Nfft,8.6); // Kaisser with alpha=8.6
      end; 
      // this is folded freq 
      ff = (-Nfft/2:1:(Nfft/2)-1)./Nfft;
      // reset spectrum - set folded spectrum according to ZOOM and center frequency
      s_sp1 = reset_spec(s_sp1, Nfft, ff, 0.0, 0);
      s_sp2 = reset_spec(s_sp2, Nfft, ff, 0.0, 0);
      s_sp3 = reset_spec(s_sp3, Nfft, ff, 0.0, 0);
      avg = 1; 
    end   

    // data for spectral analysis must be collected with ceo == 0 
    SCI_PROC(p_fft_x1, [ce,n_ce], Cmod );
    SCI_PROC(p_fft_x2, [ce,n_ce], Niq );
    SCI_PROC(p_fft_x3, [ce,n_ce], C );
    // proc data
    s_sp1 = calc_spec(s_sp1,winfft);
    s_sp2 = calc_spec(s_sp2,winfft);
    s_sp3 = calc_spec(s_sp3,winfft);

    // ---   fig1
    scf(h_fig1);
    clf(h_fig1); // xbasc();
    xtitle(Figmenu1);
    select Figopt1        
      case "opt1"            
        plot2d3(0:N-1, double(Cint), rect=[0, 0, N, M], style=3);
      case "opt2"
        if (FFT_LOG == 1)
          plot2d(s_sp1.ff,20*log10(s_sp1.spect),     rect=[s_sp1.minff, REF_dB-RANGE_dB, s_sp1.maxff, REF_dB], style=5);
          plot2d(s_sp1.ff,20*log10(s_sp1.avg_spect), rect=[s_sp1.minff, REF_dB-RANGE_dB, s_sp1.maxff, REF_dB], style=2);
        else
          plot2d(s_sp1.ff,s_sp1.spect,     rect=[s_sp1.minff,0,s_sp1.maxff, REF_FFT], style=5);
          plot2d(s_sp1.ff,s_sp1.avg_spect, rect=[s_sp1.minff,0,s_sp1.maxff, REF_FFT], style=2);
        end
        xgrid();
      case "opt3"
        if (FFT_LOG == 1)
          plot2d(s_sp2.ff,20*log10(s_sp2.spect),     rect=[s_sp2.minff, REF_dB-RANGE_dB, s_sp2.maxff, REF_dB], style=5);
          plot2d(s_sp2.ff,20*log10(s_sp2.avg_spect), rect=[s_sp2.minff, REF_dB-RANGE_dB, s_sp2.maxff, REF_dB], style=2);
        else
          plot2d(s_sp2.ff,s_sp2.spect,     rect=[s_sp2.minff,0,s_sp2.maxff, REF_FFT], style=5);
          plot2d(s_sp2.ff,s_sp2.avg_spect, rect=[s_sp2.minff,0,s_sp2.maxff, REF_FFT], style=2);
        end
        xgrid();    
      case "opt4"
        if (FFT_LOG == 1)
          plot2d(s_sp3.ff,20*log10(s_sp3.spect),     rect=[s_sp3.minff, REF_dB-RANGE_dB, s_sp3.maxff, REF_dB], style=5);
          plot2d(s_sp3.ff,20*log10(s_sp3.avg_spect), rect=[s_sp3.minff, REF_dB-RANGE_dB, s_sp3.maxff, REF_dB], style=2);
        else
          plot2d(s_sp3.ff,s_sp3.spect,     rect=[s_sp3.minff,0,s_sp3.maxff, REF_FFT], style=5);
          plot2d(s_sp3.ff,s_sp3.avg_spect, rect=[s_sp3.minff,0,s_sp3.maxff, REF_FFT], style=2);
        end
        xgrid();
    end
        
    // ---   fig2
    scf(h_fig2);
    clf(h_fig2); // xbasc();        
    xtitle(Figmenu2);
    select Figopt2        
      case "opt1"            
        subplot(2,1,1);  
        plot2d3(0:N-1, real(Ciq), rect=[0,-1.5,N,+1.5], style=2); // blue
        subplot(2,1,2);
        plot2d3(0:N-1,  imag(Ciq), rect=[0,-1.5,N,+1.5], style=5);  // red 
       case "opt2"
        subplot(2,1,1);
        plot2d(0:Nfft-1,real(s_sp1.sig),rect=[0,-1.5,Nfft,1.5] ,style=2);
        subplot(2,1,2);
        plot2d(0:Nfft-1,imag(s_sp1.sig),rect=[0,-1.5,Nfft,1.5] ,style=5);             
      case "opt3"
        subplot(2,1,1);
        plot2d(0:Nfft-1,real(s_sp2.sig),rect=[0,-1.5,Nfft,1.5] ,style=2);
        subplot(2,1,2);
        plot2d(0:Nfft-1,imag(s_sp2.sig),rect=[0,-1.5,Nfft,1.5] ,style=5);             
      case "opt4"
        subplot(2,1,1);
        plot2d(0:Nfft-1,real(s_sp3.sig),rect=[0,-1.5,Nfft,1.5] ,style=2);
        subplot(2,1,2);
        plot2d(0:Nfft-1,imag(s_sp3.sig),rect=[0,-1.5,Nfft,1.5] ,style=5);             
    end

    // ---   fig3 
    scf(h_fig3);
    clf(h_fig3); // xbasc();        
    xtitle(Figmenu3);
    select Figopt3        
      case "opt1"            
        plot2d3(0:N-1,  bert_state, rect=[0,0,N,BERT_FSM_SYNC+1],style=1);  //         
      case "opt2"
        subplot(2,1,1);
        plot2d(0:Nfft-1,real(s_sp1.wsig),rect=[0,-1.5,Nfft,1.5] ,style=2);
        subplot(2,1,2);
        plot2d(0:Nfft-1,imag(s_sp1.wsig),rect=[0,-1.5,Nfft,1.5] ,style=5);             
      case "opt3"
        subplot(2,1,1);
        plot2d(0:Nfft-1,real(s_sp2.wsig),rect=[0,-1.5,Nfft,1.5] ,style=2);
        subplot(2,1,2);
        plot2d(0:Nfft-1,imag(s_sp2.wsig),rect=[0,-1.5,Nfft,1.5] ,style=5);             
      case "opt4"
        subplot(2,1,1);
        plot2d(0:Nfft-1,real(s_sp3.wsig),rect=[0,-1.5,Nfft,1.5] ,style=2);
        subplot(2,1,2);
        plot2d(0:Nfft-1,imag(s_sp3.wsig),rect=[0,-1.5,Nfft,1.5] ,style=5);             
    end

    // ---   fig4
    scf(h_fig4);
    clf(h_fig4); // xbasc();
    xtitle(Figmenu4);
    select Figopt4        
      case "opt1"            
        C_cb = SCI_GET(p_cb_x1, SCI_PEEK_VEC);
        S_cb = SCI_GET(p_cb_x2, SCI_PEEK_VEC);            
        plot2d(real(S_cb),  imag(S_cb), rect=[-1.0,-1.0,+1.0,+1.0], style=-1);  // black +
        plot2d(real(C_cb),  imag(C_cb), rect=[-1.0,-1.0,+1.0,+1.0]);  // dot
        a=get("current_axes");
        p=a.children(1).children(1);
        p.visible = "off";
        p.line_mode = "off";
        p.thickness = 4.0;
        p.mark_style=0; // 0 is dot
        p.mark_foreground=5; // 5 is red
        p.visible = "on";
      case "opt2"
        subplot(2,1,1);  
        plot2d3(0:N-1, real(C), rect=[0,-1.5,N,+1.5], style=2); // blue
        subplot(2,1,2);
        plot2d3(0:N-1,  imag(C), rect=[0,-1.5,N,+1.5], style=5);  // red 
      case "opt3"
        subplot(2,1,1);  
        plot2d3(0:N-1, real(Niq), rect=[0,-1.5,N,+1.5], style=2); // blue
        subplot(2,1,2);
        plot2d3(0:N-1,  imag(Niq), rect=[0,-1.5,N,+1.5], style=5);  // red 
      case "opt4"
        xbasc();            
    end
  end; //   if (button_state1=='cont')
  time_up=time_up+1;
  realtime(time_up); // wait for next unit
  printf("\r%d",time_up);
end; //while (1==1)

csim_tcl_win_destroy();
TCL_EvalStr("catch { destroy  $::tkGetConf::win  }");
xdel(winsid());
SCI_DESTROY(p_prbs1);
SCI_DESTROY(p_b2i1);
SCI_DESTROY(p_i2b1);
SCI_DESTROY(p_mod1);
SCI_DESTROY(p_mod2);
SCI_DESTROY(p_dem1);
SCI_DESTROY(p_rms_x1);
SCI_DESTROY(p_rms_x2);
SCI_DESTROY(p_rms_x3);
SCI_DESTROY(p_rms_x4);
SCI_DESTROY(p_bert1);
SCI_DESTROY(p_cb_x1);
SCI_DESTROY(p_cb_x2);
SCI_DESTROY(p_fft_x1);
SCI_DESTROY(p_fft_x2);
SCI_DESTROY(p_fft_x3);
SCI_DESTROY(p_nco1);
SCI_DESTROY(p_ejp1);
SCI_DESTROY(p_ejp2);
SCI_DESTROY(p_mix_x1);


printf("\nEnd of operation\n");

