// ------------------------------------------
// load config struct in text
function [confstruct,err]=loadconfig(conffilename)
  
  confstruct=struct();
  [fd,err]=mopen(conffilename , "r");
  if ( err ==0 )
    [n,confstruct.MOD] = mfscanf(fd,"MOD=%s\n");
    [n,confstruct.M] = mfscanf(fd,"M=%d\n");
    [n,confstruct.RMS_MAV] = mfscanf(fd,"RMS_MAV=%d\n");
    mfscanf(fd,"C_NdB=");
    // C_Nmin C_Nmax C_N0 - initial value in dB
    [n,confstruct.C_N_set] = mfscanf(3,fd,"%f");
    mfscanf(fd,"\n");
    [n,confstruct.PRBS] = mfscanf(fd,"PRBS=%d\n");
    [n,confstruct.N_GCB] = mfscanf(fd,"N_GCB=%d\n");
    [n,confstruct.N_FFT] = mfscanf(fd,"N_FFT=%d\n");
    [n,confstruct.FPM] = mfscanf(fd,"FPM=%f\n");
    mfscanf(fd,"PMdB=");
    // PMmin PMmax PM0 - initial value in dB
    [n,confstruct.PM_set] = mfscanf(3,fd,"%f");
    mfscanf(fd,"\n");    
  end;
  mclose(fd);
endfunction

