//! BASIC COFDM

clear;
clearglobal;
clc;
lines(0);
path=get_absolute_file_path("app03.sce")
chdir(path);
pwd
//---------------------------
$API="..\..\lib\sci_api1.sci";
dbg=0;
exec($API);  
//---------------------------
$FUNC="..\..\lib\sci_func1.sci";
exec($FUNC);  
//---------------------------
$FUN_SPEC="..\common\sci_spect1.sci";
exec($FUN_SPEC);  
//---------------------------
// Fig 1,2,4
$X_WINDOWS="..\common\sci_fig4_1.sci";
xdel(winsid());
//---------------------------
// TK IFACE script
$TK_IFACE="sci_tk_app03_v1.sci";
//---------------------------
// script to get data from config files 
$SCRIPT_READ_DATA_FILES="sci_app03_read_data.sci";

// TK GetConfig 
$TK_CONFIG = "..\common\sci_tk_getcfg_v1.sci";
$SCI_CONFIG=".\sci_app03_cfg.sci"
exec($TK_CONFIG);
exec($SCI_CONFIG);

// simulation setup
conf_filename=csim_tkgetconfig(".\conf\conf_def.cfg",".\conf")
[sim_conf,err]=loadconfig(conf_filename);
disp(sim_conf);

// GP variables
NULL=0;
// constellation buffer size
CONSTEL_PLOT_BUFF_SIZE = 1024;

//---------------------------
// NFFT - FFT size 
NFFT=sim_conf.NFFT;
// CP - cylix prefix
CP=sim_conf.CP;
// QAM size
M=sim_conf.M;
// modulator TX scaling
TX_SCALE=sim_conf.TX_SCALE;
// pilots amplitude
PA = sim_conf.PA;
// path to data
DATA_BYTES= sim_conf.DATA_BYTES;
// path to pilots 
PILOT_BITS=sim_conf.PILOT_BITS;
// path to pilot indexes
PILOT_INDX = sim_conf.PILOT_INDX;
// path to zero indexes
ZERO_INDX=sim_conf.ZERO_INDX;
// data scrambling poly
DATA_PRBS=sim_conf.DATA_PRBS;
// path to zero indexes
PILOT_PRBS=sim_conf.PILOT_PRBS;

// RMS moving average size
RMS_MAV=sim_conf.RMS_MAV;
// number of COFDM symbols per simulation step
N_SYMB=sim_conf.N_SYMB;
//  CDdB=[min max initial]
C_N_set=sim_conf.C_N_set;

//---------------------------
exec($SCRIPT_READ_DATA_FILES);  

//---------------------------
// START OF DEV CREATION
// modulator
p_bb1 = SCI_CREATE(SCI_BINBUFF);
p_bb2 = SCI_CREATE(SCI_BINBUFF);
p_i2b1 = SCI_CREATE(SCI_INT2BIN);
p_b2i1 = SCI_CREATE(SCI_BIN2INT);
p_prbs1 = SCI_CREATE(SCI_LFSR);
p_prbs2 = SCI_CREATE(SCI_LFSR);
p_mod1 = SCI_CREATE(SCI_COFDM_MOD);
p_map1 = SCI_CREATE(SCI_COFDM_MAP);
p_cb_x1 = SCI_CREATE(SCI_CIRCBUFF_X);
// demodulator
p_cb_x2 = SCI_CREATE(SCI_CIRCBUFF_X);
p_dem1 = SCI_CREATE(SCI_COFDM_DEM);
p_demap1 = SCI_CREATE(SCI_COFDM_DEMAP);
p_map2 = SCI_CREATE(SCI_COFDM_MAP);
p_sel1 = SCI_CREATE(SCI_COFDM_SEL);
p_sel2 = SCI_CREATE(SCI_COFDM_SEL);
p_sel3 = SCI_CREATE(SCI_COFDM_SEL);
p_sel4 = SCI_CREATE(SCI_COFDM_SEL);
p_sel5 = SCI_CREATE(SCI_COFDM_SEL);
p_sel6 = SCI_CREATE(SCI_COFDM_SEL);
p_i2b2 = SCI_CREATE(SCI_INT2BIN);

// WGN_X - complex noise generator
p_wgn_x1 = SCI_CREATE(SCI_WGN_X);


// measure
// RMS1 to measure samples of Ct
p_rms_x1 = SCI_CREATE(SCI_RMS_X);
// RMS2 to measure noise
p_rms_x2 = SCI_CREATE(SCI_RMS_X);
// RMS3 to measure sliced IQ carriers
p_rms_x3 = SCI_CREATE(SCI_RMS_X);
// RMS4 to measure IQ error
p_rms_x4 = SCI_CREATE(SCI_RMS_X);

// plot buffers
// TX time domain COFDM symbol
p_gb_x1 = SCI_CREATE(SCI_CIRCBUFF_X);
// RX time domain COFDM symbol
p_gb_x2 = SCI_CREATE(SCI_CIRCBUFF_X);
// constellation plots - DEMODULATED CARRIERS
// demodulated carriers
p_gb_x3 = SCI_CREATE(SCI_CIRCBUFF_X);
SCI_SET(p_gb_x3, SCI_SIZE, CONSTEL_PLOT_BUFF_SIZE);
// sliced carriers
p_gb_x4 = SCI_CREATE(SCI_CIRCBUFF_X);
SCI_SET(p_gb_x4, SCI_SIZE, CONSTEL_PLOT_BUFF_SIZE);
// demodulated data carriers
p_gb_x5 = SCI_CREATE(SCI_CIRCBUFF_X);
SCI_SET(p_gb_x5, SCI_SIZE, CONSTEL_PLOT_BUFF_SIZE);
// demodulated pilot carriers
p_gb_x6 = SCI_CREATE(SCI_CIRCBUFF_X);
SCI_SET(p_gb_x6, SCI_SIZE, CONSTEL_PLOT_BUFF_SIZE);
// sliced data carriers
p_gb_x7 = SCI_CREATE(SCI_CIRCBUFF_X);
SCI_SET(p_gb_x7, SCI_SIZE, CONSTEL_PLOT_BUFF_SIZE);
// sliced pilot carriers
p_gb_x8 = SCI_CREATE(SCI_CIRCBUFF_X);
SCI_SET(p_gb_x8, SCI_SIZE, CONSTEL_PLOT_BUFF_SIZE);
// error data carriers
p_gb_x9 = SCI_CREATE(SCI_CIRCBUFF_X);
SCI_SET(p_gb_x9, SCI_SIZE, CONSTEL_PLOT_BUFF_SIZE);
// error pilot carriers
p_gb_x10 = SCI_CREATE(SCI_CIRCBUFF_X);
SCI_SET(p_gb_x10, SCI_SIZE, CONSTEL_PLOT_BUFF_SIZE);

// Carrier level calculation:
select ( M )
  case 4 then Crms_QAM=0.7071068; 
  case 16 then Crms_QAM=0.7905694;
  case 64 then Crms_QAM=0.8100926; 
  case 256 then Crms_QAM=0.8149003;
  else
    printf("\n !!! Unknown constellation M = %d \n", M );
    abort;
end
// BPSK pilots are busted - PA
Crms_BPSK  = PA
NPil = max(size(pindx));
NZero = max(size(zindx));
NCarr=NFFT - NPil - NZero
if (NCarr <> max(size(cindx)))
  printf("\n !!! Bad number of carriers Ncarr= %d \n", NCarr );
  abort;    
end
// mod is normalized - y = sum( carriers )/sqrt(N)
// carriers are orthogonal so:
C_rms = TX_SCALE*sqrt(NCarr*Crms_QAM^2 + NPil*Crms_BPSK^2)/sqrt(NFFT)


// symbols in bits
W = ceil(log2(M));

// MODULATOR FIXED settings 
// data comes in bytes
SCI_SET(p_i2b1, SCI_SYMBOL_SIZE, 8);
// binary buffers for symbol/pilots generation
// data binbuffer size in bits
SCI_SET(p_bb1, SCI_SIZE, 8*max(size(data_bytes)));
SCI_SET(p_bb1, SCI_SYMBOL_SIZE, W);
// pilots in bits
SCI_SET(p_bb2, SCI_SYMBOL_SIZE, 1);
SCI_SET(p_bb2, SCI_SIZE, max(size(pilot_bits)));
// data scrambler
SCI_SET(p_prbs1, SCI_PRBS, DATA_PRBS);
SCI_SET(p_prbs1, SCI_SYMBOL_SIZE, W);
// pilot scrambler
SCI_SET(p_prbs2, SCI_PRBS, PILOT_PRBS);
SCI_SET(p_prbs2, SCI_SYMBOL_SIZE, 1);
// b2i converter
SCI_SET(p_b2i1, SCI_SYMBOL_SIZE, W);
// set modulator mapper 
SCI_SET(p_map1, SCI_COFDM_NFFT, NFFT);
SCI_SET(p_map1, SCI_COFDM_QAM_SIZE, M);
SCI_SET(p_map1, SCI_COFDM_PA, PA);
SCI_SET(p_map1, SCI_COFDM_DATA_INDEXES, cindx);
SCI_SET(p_map1, SCI_COFDM_PILOT_INDEXES, pindx);
SCI_SET(p_map1, SCI_COFDM_ZERO_INDEXES, zindx);
// set modulator
SCI_SET(p_mod1, SCI_COFDM_NFFT, NFFT);
SCI_SET(p_mod1, SCI_COFDM_CP, CP);
// default scaling is set by NFFT, CP
// so change must modify value already set
SCI_SET(p_mod1, SCI_SCALE, TX_SCALE * SCI_GET(p_mod1, SCI_SCALE ) );
// samples buffer
SCI_SET(p_cb_x1, SCI_SIZE, NFFT+CP);

// DEMODULATOR FIXED setings 
SCI_SET(p_cb_x2, SCI_SIZE, NFFT+CP);
// set demodulator
SCI_SET(p_dem1, SCI_COFDM_NFFT, NFFT);
SCI_SET(p_dem1, SCI_COFDM_CP, CP);
// default scaling is set by NFFT, CP
// so change must modify value already set
SCI_SET(p_dem1, SCI_SCALE, SCI_GET(p_dem1, SCI_SCALE )/ TX_SCALE);
// set demapper 
SCI_SET(p_demap1, SCI_COFDM_NFFT, NFFT);
SCI_SET(p_demap1, SCI_COFDM_QAM_SIZE, M);
SCI_SET(p_demap1, SCI_COFDM_PA, PA);
SCI_SET(p_demap1, SCI_COFDM_DATA_INDEXES, cindx);
SCI_SET(p_demap1, SCI_COFDM_PILOT_INDEXES, pindx);
SCI_SET(p_demap1, SCI_COFDM_ZERO_INDEXES, zindx);
// set demodulator mapper 
SCI_SET(p_map2, SCI_COFDM_NFFT, NFFT);
SCI_SET(p_map2, SCI_COFDM_QAM_SIZE, M);
SCI_SET(p_map2, SCI_COFDM_PA, PA);
SCI_SET(p_map2, SCI_COFDM_DATA_INDEXES, cindx);
SCI_SET(p_map2, SCI_COFDM_PILOT_INDEXES, pindx);
SCI_SET(p_map2, SCI_COFDM_ZERO_INDEXES, zindx);
// set sel to carriers
SCI_SET(p_sel1, SCI_COFDM_NFFT, NFFT);
SCI_SET(p_sel1, SCI_COFDM_SEL_INDEXES, cindx);
SCI_SET(p_sel3, SCI_COFDM_NFFT, NFFT);
SCI_SET(p_sel3, SCI_COFDM_SEL_INDEXES, cindx);
SCI_SET(p_sel5, SCI_COFDM_NFFT, NFFT);
SCI_SET(p_sel5, SCI_COFDM_SEL_INDEXES, cindx);
// set sel to pilots
SCI_SET(p_sel2, SCI_COFDM_NFFT, NFFT);
SCI_SET(p_sel2, SCI_COFDM_SEL_INDEXES, pindx);
SCI_SET(p_sel4, SCI_COFDM_NFFT, NFFT);
SCI_SET(p_sel4, SCI_COFDM_SEL_INDEXES, pindx);
SCI_SET(p_sel6, SCI_COFDM_NFFT, NFFT);
SCI_SET(p_sel6, SCI_COFDM_SEL_INDEXES, pindx);
// data symbols in bits
SCI_SET(p_i2b2, SCI_SYMBOL_SIZE, W);

// RMS
SCI_SET(p_rms_x1, SCI_SIZE, RMS_MAV);
SCI_SET(p_rms_x2, SCI_SIZE, RMS_MAV);
SCI_SET(p_rms_x3, SCI_SIZE, RMS_MAV);
SCI_SET(p_rms_x4, SCI_SIZE, RMS_MAV);

//---------------------------------------------------------
// INIT DATA PROCESSING
//---------------------------------------------------------
// data bytes into bmat
data_bmat = SCI_PROC(p_i2b1, CE_1(data_bytes), data_bytes);
// make bvec from bmat row-wise
data_bvec = rvectorize(data_bmat);
// load data binbuffer 
SCI_SET(p_bb1, SCI_VEC, data_bvec);
// load pilot binbuffer 
SCI_SET(p_bb2, SCI_VEC, to_bvec(pilot_bits));
//---------------------------------------------------------

// ------- RMS ----------------------
RMS1 = 0.0; RMS2 = 0.0; RMS3 = 0.0; RMS4 = 0.0;
// ------- C/N ----------------------
AWGN_flag = 0;
// ------- BER ----------------------
ber=[0, 0]; BER=[0,0];
// There is no BERT - so it is as though it is always locked
BERT_LOCK_FLAG = %T;
BERT_CLEAR_FLAG = %F;

// tk and global access variables
exec($TK_IFACE);
exec($X_WINDOWS);

N_opt1 = TCL_GetVar('Nopt');
N_symb=floor(sscanf(N_opt1,"%d"));

// set delay timer unit
// realtimeinit(0.25);        // timepass unit
realtimeinit(1);              // timepass unit
realtime(0);                  // first call sets init time
time_up=0;
avg = 0;

printf("Current time=\n");
printf("%d",time_up);

// variables must exist to be set-up properly
button_state1=TCL_GetVar('button_state')
button_state2=button_state1;


while (1==1)
  TCL_EvalStr('set h [winfo exists .app3]');
  if TCL_GetVar("h")=='0' then break, end
  Update_TCLTK();
  if (button_state1=='state_RUN') then
    
    N = N_symb*(NFFT+CP);    
    SCI_SET(p_gb_x1, SCI_SIZE, N);
    SCI_SET(p_gb_x2, SCI_SIZE, N);
    
    for (n=1:N_symb) 

      // C_N=20*log(C_rms/N_rms)
      N_rms = RMS1/ 10^(C_N/20);
      SCI_SET(p_wgn_x1, SCI_SIGMA, N_rms);
      // AWGN noise 
      if ( AWGN_flag )
        Niq = SCI_GEN(p_wgn_x1, CE_1(1:NFFT+CP));
      else
        Niq = zeros(NFFT+CP,1)+%i*zeros(NFFT+CP,1);
      end  

      // gen symbols out of binbuffer of cindx size
      symb_bmat = SCI_GEN(p_bb1,CE_1(cindx));
      // gen scramble
      symb_prbs = SCI_GEN(p_prbs1,CE_1(cindx));
      // scrambled symbols
      symb_bmat_tx = xor(symb_bmat,symb_prbs);
      // disp([symb_bmat,symb_prbs,symb_bmat_tx]);
      // gen pilots out of binbuffer of pindx size
      pilot_bvec = SCI_GEN(p_bb2,CE_1(pindx));
      // gen scramble
      pilot_prbs = SCI_GEN(p_prbs2,CE_1(pindx));
      // scambled pilots
      pilot_tx = xor(pilot_bvec,pilot_prbs);
      // disp([pilot_bvec,pilot_prbs,pilot_tx]);
      symb_tx = SCI_PROC(p_b2i1, CE_1(cindx), symb_bmat_tx);
      SCI_SET(p_map1, SCI_COFDM_DATA, symb_tx);
      SCI_SET(p_map1, SCI_COFDM_PILOTS, pilot_tx);
      carr_tx = SCI_GET(p_map1, SCI_COFDM_CARRIERS);
      // modulate FFT^-1
      SCI_SET(p_mod1, SCI_COFDM_CARRIERS, carr_tx);
      samp_tx = SCI_GET(p_mod1, SCI_COFDM_SYMBOL);
      // samp_rx => samp_tx;        
      SCI_SET(p_cb_x1, SCI_VEC, samp_tx);
      // [cei|ceo]=[0|1] -> samples out
      Ctx = SCI_PROC(p_cb_x1,[CE_0(1:NFFT+CP),CE_1(1:NFFT+CP)],samp_tx);
      // add noise
      Crx = Ctx+Niq;
      // receiver
      SCI_PROC(p_cb_x2,[CE_1(1:NFFT+CP),CE_0(1:NFFT+CP)],Crx);
      samp_rx=SCI_GET(p_cb_x2, SCI_VEC);
      // demodulate
      SCI_SET(p_dem1, SCI_COFDM_SYMBOL, samp_rx);
      carr_rx = SCI_GET(p_dem1, SCI_COFDM_CARRIERS);
      // demap
      SCI_SET(p_demap1, SCI_COFDM_CARRIERS, carr_rx);
      symb_rx = SCI_GET(p_demap1, SCI_COFDM_DATA);
      pilot_rx = SCI_GET(p_demap1, SCI_COFDM_PILOTS);
      //disp([symb_tx, symb_rx]);
      //disp([to_vec(pilot_tx), to_vec(pilot_rx)]);
      symb_bmat_rx = SCI_PROC(p_i2b2, CE_1(cindx), symb_rx);
      symb_bmat_err = xor( symb_bmat_tx, symb_bmat_rx );
      pilot_err = xor( pilot_rx, pilot_tx );
        
      err_cnt_data = sum(to_mat(symb_bmat_err));
      err_cnt_pilot = sum(to_vec(pilot_err));
      [nr,nc] = size(symb_bmat_rx);
      bit_cnt_data = nr*nc;   
      ber(1) = err_cnt_data; ber(2) = bit_cnt_data;            
      if ( BERT_CLEAR_FLAG )              
        printf(" BERT_CLEARED\n");
        BERT_CLEAR_FLAG = %F;
        BER(1) = ber(1);
        BER(2) = ber(2);
      else
        BER(1) = BER(1) + ber(1);
        BER(2) = BER(2) + ber(2);                  
      end                
        
      // re-map sliced carriers 
      SCI_SET(p_map2, SCI_COFDM_DATA, symb_rx);
      SCI_SET(p_map2, SCI_COFDM_PILOTS, pilot_rx);
      // carrier errors 
      carr_sliced = SCI_GET(p_map2, SCI_COFDM_CARRIERS);
      carr_err = carr_rx - carr_sliced;            
      // measure signal samples
      C_rms = SCI_PROC(p_rms_x1, CE_1(1:NFFT+CP), Ctx);       
      RMS1= mean(C_rms);
     // measure noise samples
      Niq_rms = SCI_PROC(p_rms_x2, CE_1(1:NFFT+CP), Niq);       
      RMS2= mean(Niq_rms);
      // measure sliced signal samples
      Eiq_rms = SCI_PROC(p_rms_x3, CE_1(1:NFFT), carr_sliced);       
      RMS3= mean(Eiq_rms);
     // measure constellation error
      Siq_rms = SCI_PROC(p_rms_x4, CE_1(1:NFFT), carr_err);       
      RMS4= mean(Siq_rms);

      // select carriers - all data and pilot selectors have same settings - it could be just one pair...
      // rx data carriers
      SCI_SET(p_sel1, SCI_COFDM_CARRIERS, carr_rx);
      d_carr_rx = SCI_GET(p_sel1, SCI_COFDM_SEL_CARRIERS);
      // rx pilot carriers
      SCI_SET(p_sel2, SCI_COFDM_CARRIERS, carr_rx);
      p_carr_rx = SCI_GET(p_sel2, SCI_COFDM_SEL_CARRIERS);
      // sliced data carriers
      SCI_SET(p_sel3, SCI_COFDM_CARRIERS, carr_sliced);
      d_carr_sliced = SCI_GET(p_sel3, SCI_COFDM_SEL_CARRIERS);
      // sliced pilot carriers
      SCI_SET(p_sel4, SCI_COFDM_CARRIERS, carr_sliced);
      p_carr_sliced = SCI_GET(p_sel4, SCI_COFDM_SEL_CARRIERS);
      // error data carriers
      SCI_SET(p_sel5, SCI_COFDM_CARRIERS, carr_err);
      d_carr_err = SCI_GET(p_sel5, SCI_COFDM_SEL_CARRIERS);
      // sliced pilot carriers
      SCI_SET(p_sel6, SCI_COFDM_CARRIERS, carr_err);
      p_carr_err = SCI_GET(p_sel6, SCI_COFDM_SEL_CARRIERS);

      // store samples in plot buffers
      SCI_PROC(p_gb_x1,[CE_1(1:NFFT+CP),CE_0(1:NFFT+CP)],Ctx);
      SCI_PROC(p_gb_x2,[CE_1(1:NFFT+CP),CE_0(1:NFFT+CP)],Crx);
      // store demodulated and sliced carriers in plot buffers
      SCI_PROC(p_gb_x3,[CE_1(1:NFFT),CE_0(1:NFFT)],carr_rx);
      SCI_PROC(p_gb_x4,[CE_1(1:NFFT),CE_0(1:NFFT)],carr_sliced);
      // store demodulated and sliced carriers in plot buffers
      SCI_PROC(p_gb_x5,[CE_1(cindx),CE_0(cindx)],d_carr_rx);
      SCI_PROC(p_gb_x6,[CE_1(pindx),CE_0(pindx)],p_carr_rx);
      // store demodulated and sliced carriers in plot buffers
      SCI_PROC(p_gb_x7,[CE_1(cindx),CE_0(cindx)],d_carr_sliced);
      SCI_PROC(p_gb_x8,[CE_1(pindx),CE_0(pindx)],p_carr_sliced);
      // store demodulated and sliced carriers in plot buffers
      SCI_PROC(p_gb_x9,[CE_1(cindx),CE_0(cindx)],d_carr_err);
      SCI_PROC(p_gb_x10,[CE_1(pindx),CE_0(pindx)],p_carr_err);
      
      
    end // for(n=1:N_symb)

    Ctx_gb = SCI_GET(p_gb_x1, SCI_PEEK_VEC);                // time domain symbol TX-ed
    Crx_gb = SCI_GET(p_gb_x2, SCI_PEEK_VEC);                // time domain symbol RX-ed
    Cd_gb = SCI_GET(p_gb_x3, SCI_PEEK_VEC);                 // demodulated carriers IQ 
    Cs_gb = SCI_GET(p_gb_x4, SCI_PEEK_VEC);                 // sliced carriers IQ
    d_carr_gb = SCI_GET(p_gb_x5, SCI_PEEK_VEC);             // demodulated data carriers IQ
    p_carr_gb = SCI_GET(p_gb_x6, SCI_PEEK_VEC);             // demodulated pilot carriers IQ
    d_carr_sliced_gb = SCI_GET(p_gb_x7, SCI_PEEK_VEC);      // sliced data carriers IQ 
    p_carr_sliced_gb = SCI_GET(p_gb_x8, SCI_PEEK_VEC);      // sliced pilot carriers IQ
    d_carr_err_gb = SCI_GET(p_gb_x9, SCI_PEEK_VEC);         // error data carriers IQ 
    p_carr_err_gb = SCI_GET(p_gb_x10, SCI_PEEK_VEC);         // error pilot carriers IQ

    // ---   fig1
    scf(h_fig1);
    clf(h_fig1);
    xtitle(Figmenu1);
    select Figopt1
      case "opt1"
        subplot(2,1,1);  
        plot2d3(0:N-1, real(Ctx_gb), rect=[0,-2.5,N,+2.5], style=2);
        subplot(2,1,2);  
        plot2d3(0:N-1, imag(Ctx_gb), rect=[0,-2.5,N,+2.5], style=3);
      case "opt2"
        clf(h_fig1);
      case "opt3"
        clf(h_fig1);
      case "opt4"
        clf(h_fig1);
    end
  
    // ---   fig2
    scf(h_fig2);
    clf(h_fig2);
    xtitle(Figmenu2);
    select Figopt2
      case "opt1" 
        subplot(2,1,1);  
        plot2d3(0:N-1, real(Crx_gb), rect=[0,-2.5,N,+2.5], style=2);
        subplot(2,1,2);  
        plot2d3(0:N-1, imag(Crx_gb), rect=[0,-2.5,N,+2.5], style=3);
      case "opt2"
        clf(h_fig2);
      case "opt3"
        clf(h_fig2);
      case "opt4"
        clf(h_fig2));
    end
    
    // ---   fig3
    scf(h_fig3);
    clf(h_fig3);
    xtitle(Figmenu3);
    select Figopt3        
      case "opt1" // demodulated data carriers IQ
        plot2d(real(d_carr_sliced_gb),  imag(d_carr_sliced_gb), rect=[-1.0,-1.0,+1.0,+1.0], style=-1);  // black +
        plot2d(real(d_carr_gb),  imag(d_carr_gb), rect=[-1.0,-1.0,+1.0,+1.0]);  // dot
        a=get("current_axes");
        p=a.children(1).children(1);
        p.visible = "off";
        p.line_mode = "off";
        p.thickness = 4.0;
        p.mark_style=0; // 0 is dot
        p.mark_foreground=5; // 5 is red
        p.visible = "on";
      case "opt2" // demodulated data carriers errors IQ
        plot2d(real(d_carr_err_gb),  imag(d_carr_err_gb), rect=[-1.0,-1.0,+1.0,+1.0]);  // dot
        a=get("current_axes");
        p=a.children(1).children(1);
        p.visible = "off";
        p.line_mode = "off";
        p.thickness = 4.0;
        p.mark_style=0; // 0 is dot
        p.mark_foreground=5; // 5 is red
        p.visible = "on";
      case "opt3" // sliced data carriers IQ
        plot2d(real(d_carr_sliced_gb),  imag(d_carr_sliced_gb), rect=[-1.0,-1.0,+1.0,+1.0], style=-1);  // black +
      case "opt4" // all demodulated carriers IQ
        plot2d(real(Cs_gb),  imag(Cs_gb), rect=[-1.0,-1.0,+1.0,+1.0], style=-1);  // black +
        plot2d(real(Cd_gb),  imag(Cd_gb), rect=[-1.0,-1.0,+1.0,+1.0]);  // dot
        a=get("current_axes");
        p=a.children(1).children(1);
        p.visible = "off";
        p.line_mode = "off";
        p.thickness = 4.0;
        p.mark_style = 0; // 0 is dot
        p.mark_foreground = 5; // 5 is red
        p.visible = "on";
    end

    // ---   fig4
    scf(h_fig4);
    clf(h_fig4);
    xtitle(Figmenu4);
    select Figopt4
      case "opt1" // demodulated pilot carriers IQ
        plot2d(real(p_carr_sliced_gb),  imag(p_carr_sliced_gb), rect=[-1.0,-1.0,+1.0,+1.0], style=-1);  // black +
        plot2d(real(p_carr_gb),  imag(p_carr_gb), rect=[-1.0,-1.0,+1.0,+1.0]);  // dot
        a=get("current_axes");
        p=a.children(1).children(1);
        p.visible = "off";
        p.line_mode = "off";
        p.thickness = 4.0;
        p.mark_style=0; // 0 is dot
        p.mark_foreground=5; // 5 is red
        p.visible = "on";
      case "opt2" // demodulated pilot errors IQ
        plot2d(real(p_carr_err_gb),  imag(p_carr_err_gb), rect=[-1.0,-1.0,+1.0,+1.0]);  // dot
        a=get("current_axes");
        p=a.children(1).children(1);
        p.visible = "off";
        p.line_mode = "off";
        p.thickness = 4.0;
        p.mark_style = 0; // 0 is dot
        p.mark_foreground = 5; // 5 is red
        p.visible = "on";
      case "opt3" 
        plot2d(real(p_carr_sliced_gb),  imag(p_carr_sliced_gb), rect=[-1.0,-1.0,+1.0,+1.0], style=-1);  // black +
      case "opt4"
        clf(h_fig4);
    end

  end; //   if (button_state1=='cont')
  
  time_up=time_up+1;
  realtime(time_up); // wait for next unit
  printf("\r%d",time_up);
end; //while (1==1)

csim_tcl_win_destroy();
TCL_EvalStr("catch { destroy  $::tkGetConf::win  }");
xdel(winsid());

//---------------------------
// modulator
SCI_DESTROY(p_bb1);
SCI_DESTROY(p_bb2);
SCI_DESTROY(p_i2b1);
SCI_DESTROY(p_b2i1);
SCI_DESTROY(p_prbs1);
SCI_DESTROY(p_prbs2);
SCI_DESTROY(p_mod1);
SCI_DESTROY(p_map1);
SCI_DESTROY(p_cb_x1);
// demodulator
SCI_DESTROY(p_cb_x2);
SCI_DESTROY(p_dem1);
SCI_DESTROY(p_demap1);
SCI_DESTROY(p_map2);
SCI_DESTROY(p_sel1);
SCI_DESTROY(p_sel2);
SCI_DESTROY(p_sel3);
SCI_DESTROY(p_sel4);
SCI_DESTROY(p_sel5);
SCI_DESTROY(p_sel6);
SCI_DESTROY(p_i2b2);
// measure
SCI_DESTROY(p_rms_x1);
SCI_DESTROY(p_rms_x2);
SCI_DESTROY(p_rms_x3);
SCI_DESTROY(p_rms_x4);
// graphics
SCI_DESTROY(p_gb_x1);
SCI_DESTROY(p_gb_x2);
SCI_DESTROY(p_gb_x3);
SCI_DESTROY(p_gb_x4);
SCI_DESTROY(p_gb_x5);
SCI_DESTROY(p_gb_x6);
SCI_DESTROY(p_gb_x7);
SCI_DESTROY(p_gb_x8);
SCI_DESTROY(p_gb_x9);
SCI_DESTROY(p_gb_x10);

printf("\nEnd of operation\n");

