// read data bytes and pilots bits
// read pilot and zero indexes 
// calculate cindx = (0:NFFT) - pinxd - zindx 
// data_bytes + cindx
// pilot_bits + pindx 
// zindx
//---------------------------------

// read data bytes and pilots bits
fdb=mopen(DATA_BYTES,'r');
data_bytes=mfscanf(-1,fdb,'%x ');
mclose(fdb);
fpb=mopen(PILOT_BITS,'r');
pilot_bits=mfscanf(-1,fpb,'%x ');
mclose(fpb);

// read data bytes and pilots bits
fpi=mopen(PILOT_INDX,'r');
fzi=mopen(ZERO_INDX,'r');
// read pilot indexes
pindx=mfscanf(-1,fpi,'%d ');
mclose(fpi);
[rpi,c]=size(pindx);
// read zero indexes
zindx=mfscanf(-1,fzi,'%d ');
[rzi,c]=size(zindx);
mclose(fzi);
// create carrier index 
// cindx = (0:NFFT) - pinxd - zindx 
cindx=(0:NFFT-1)';
// pilot index checks
for (i=1:rpi)
  for (j=1:rzi)
    if ( pindx(i) == zindx(j) )
      printf('ABORT - ZERO and PILOT indexes are equal pindx(%d)=%d == zindx(%d)=%d',i,pindx(i),j,zindx(j));
      abort;
    end
  end  
end
// pilot index checks
for (i=1:rpi)
  if ((pindx(i) > NFFT-1)|(pindx(i) < 0))
    printf('ABORT - BAD pilot index pindx(%d)=%d',i,pindx(i));
    abort;
  end
  for (j=1:max(size(cindx)))
    if ( cindx(j) == pindx(i) )
      cindx(j,1)=[]; //deletion of element - carrier can't be pilot 
      break;
    end
  end    
end
// zero index checks
for (i=1:rzi)
  if ((zindx(i) > NFFT-1)|(zindx(i) < 0))
    printf('ABORT - BAD zero index zindx(%d)=%d',i,zindx(i));
    abort;
  end
  for (j=1:max(size(cindx)))
    if ( cindx(j) == zindx(i) )
      cindx(j,1)=[]; //deletion of element - carrier can't be zero
      break;
    end
  end    
end
[rci,c]=size(cindx);
 
