// ------------------------------------------
// load config struct in text
function [perfStruct,err]=loadPerfConfig(perfFilename)
  
  perfStruct=struct();
  [fd,err]=mopen(perfFilename , "r");
  if ( err ==0 )
    [n,perfStruct.configFile] = mfscanf(fd,"configFile = %s\n");
    [n,perfStruct.matFile] = mfscanf(fd,"matFile = %s\n");    
    [n,perfStruct.NBW] = mfscanf(fd,"NBW = %f\n");   
    mfscanf(fd,"EsN0dB = ");
    // min max step - initial value in dB
    [n,perfStruct.EsN0dB] = mfscanf(3,fd,"%f");
    mfscanf(fd,"\n");
    [n,perfStruct.frameSamples] = mfscanf(fd,"frameSamples = %d\n");
    [n,perfStruct.bits] = mfscanf(fd,"bits = %d\n");
    [n,perfStruct.runs] = mfscanf(fd,"runs = %d\n");
  end;
  mclose(fd);
endfunction

// ------------------------------------------
// load config struct in text
function [confStruct,err]=loadSimConfig(confFilename)
  
  confStruct=struct();
  [fd,err]=mopen(confFilename , "r");
  if ( err ==0 )
    [n,confStruct.MOD] = mfscanf(fd,"MOD=%s\n");
    [n,confStruct.M] = mfscanf(fd,"M=%d\n");
    [n,confStruct.UP] = mfscanf(fd,"UP=%d\n");
    [n,confStruct.FIR_TX] = mfscanf(fd,"FIR_TX=%s\n");
    [n,confStruct.FIR_RX] = mfscanf(fd,"FIR_RX=%s\n");    
    [n,confStruct.TxDev] = mfscanf(fd,"TxDev=%f\n");
    [n,confStruct.RxDev] = mfscanf(fd,"RxDev=%f\n");   
    [n,confStruct.PRBS] = mfscanf(fd,"PRBS=%d\n");
    mfscanf(fd,"C_NdB=");
    // C_Nmin C_Nmax C_N0 - initial value in dB
    [n,confStruct.C_N_set] = mfscanf(3,fd,"%f");
    mfscanf(fd,"\n");
    [n,confStruct.RMS_MAV] = mfscanf(fd,"RMS_MAV=%d\n");    
    [n,confStruct.N_FFT] = mfscanf(fd,"N_FFT=%d\n");
    [n,confStruct.N_GCB] = mfscanf(fd,"N_GCB=%d\n");
    [n,confStruct.BERT] = mfscanf(fd,"BERT=%d\n");    
  end;
  mclose(fd);
endfunction


// argument must be scalar value  
function u=UnwrapPhase(deltaPh)
  if (abs(deltaPh) < 0.5) 
    u=0;
  elseif (deltaPh <= -0.5)
    u=1.0;
  else
    u=-1.0;
  end
endfunction    

// differentiate phase
function dp=DiffPhase(ph,ph0)
  I=max(size(ph));
  dp(1)=ph(1)-ph0+UnwrapPhase(ph(1)-ph0);
  for i=2:I  
    dp(i)=ph(i)-ph(i-1)+UnwrapPhase(ph(i)-ph(i-1));
  end  
endfunction    

// Integrate phase
function ip=IntegratePhase(dp,ip0, ce, reset)
  I=max(size(dp));
  ip=zeros(I,1);
  for i=1:I
    if (reset(i))
      ip0=0
    end   
    if (ce(i))
      ip0=ip0+dp(i);
    end           
    ip(i)=ip0;
  end    
endfunction    

// return only qualified samples 
function [y]=ReSamp(ce,a)
 y=[];
 j=1;
 I=max(size(ce));
 for i=1:I
    if (ce(i))
      y=[y', a(i,:)]'; // make it a column vector - one row is a row vector  
    end           
 end   
endfunction    


// return distance and length of two [0,1] vectors
function [e,n]=HammingDist(a,b)
    // xor     
    x=pmodulo(a+b,2);
    e=sum(x);
    n=max(size(x));
endfunction;    

