// DBG for stand alone 
DBG = 0
if DBG
 path=get_absolute_file_path("app04ModPerfChar.sci")
 chdir(path);
 clear;
 exec(".\app04ModFunc.sci");
 perfFilename = ".\perf\_default.cfg";
end
[perfConf,err] = loadPerfConfig(perfFilename);

runs = perfConf.runs
matFileName = fileparts(perfConf.matFile,'path')+fileparts(perfConf.matFile,'fname');
// create new window
h_fig=scf();    
h=gcf();
clf();
toolbar(h.figure_id,'off');
xtitle(matFileName);
for run=1:runs
  matFileNameX = matFileName+sprintf("_r%02d",run)+fileparts(perfConf.matFile,'extension');
  disp (matFileNameX);
  EsN0_BER=read(matFileNameX,-1,5);    
  if (run == 1)
    plot2d(EsN0_BER(:,1), EsN0_BER(:,2)+%eps, logflag = "nl", ...
    rect=[min(EsN0_BER(:,1))-1, 1.0E-5, max(EsN0_BER(:,1))+1, +1.0E+0],style=2 );
    xgrid();
    a = gca();
    a.x_label.text = "Es/N0[dB]";
    a.x_label.font_size = 3;
    a.y_label.text = "BER";
    a.y_label.font_size = 3;
  else
    plot2d(EsN0_BER(:,1), EsN0_BER(:,2)+%eps, logflag = "nl", frameflag=0, style=run+1 );
  end  
end
matFileNameX = matFileName+"_r00"+fileparts(perfConf.matFile,'extension');
EsN0_BER=read(matFileNameX,-1,5);
plot2d(EsN0_BER(:,1), EsN0_BER(:,2)+%eps, logflag = "nl", frameflag=0, style= -4);


