[perfConf,err] = loadPerfConfig(perfFilename);

disp(perfConf);

[simConf,err] = loadSimConfig(perfConf.configFile);
disp(simConf);
exec(".\app04ModInit.sci");
// global access variables
exec(".\app04ModGlob.sci");

ber=[0, 0]; 
BER=[0,0];
// Carier is 1.0 C^2=sqrtI^2+sqrtQ^2=2/2 
C_rms = 1.0;

EsN0dB_end = perfConf.EsN0dB(2);
EsN0dB_step = perfConf.EsN0dB(3);
SR = 1/ UP;
NBW = perfConf.NBW;
runs = perfConf.runs
ph0 =0.0;
ip0 = 0.0;
global ph0 ip0;

// global static - must be preserved outside scope of the SimApp function  
BER_bert = [0, 0];
BER_xor = [0, 0];
global winfft BER_bert BER_xor;
// frame samples are pre-defined to settle filters 
// one frame is skiped after C_N is changed to  
N=floor(perfConf.frameSamples);
// calculate number of frames per run
bitsPerFrame=floor(N/UP)* ceil(log2(M));
frames = ceil(perfConf.bits/bitsPerFrame);
// noise on 
AWGN_FLAG = 1;
// Force BER_xor wregardless off SimConfig
BERT = 0;
matFileName = fileparts(perfConf.matFile,'path')+fileparts(perfConf.matFile,'fname');

for run=1:runs
  matFileNameX = matFileName+sprintf("_r%02d",run)+fileparts(perfConf.matFile,'extension')
  // this is the way of resetting the file  - write has problems with overwriting files !
  fd_w = mopen( matFileNameX, 'wt');  
  
  EsN0dB = perfConf.EsN0dB(1);  
  i = 1;
  EsN0_BER = [];
  while (EsN0dB <= EsN0dB_end)
    // set C_N 
    C_N = EsN0dB - 10*log10(NBW/SR);    
    // C_NdB=20*log(C_rms/N_rms)
    N_rms = (C_rms/ 10^(C_N/20));
    SCI_SET(p_wgn_x1, SCI_SIGMA, N_rms);
    // one frame to settle filters 
    SimApp();
    // reset xor BER counter
    BER_xor = [0, 0];
    // and count errors
    for f=1:frames
      SimApp();
      // disp(BER)
      // disp(BER_xor)
    end
    EsN0_BER(i,1) = EsN0dB;
    EsN0_BER(i,2) = BER(1)/BER(2);
    EsN0_BER(i,3) = BER(1);
    EsN0_BER(i,4) = BER(2);
    EsN0_BER(i,5) = C_N;
    disp(EsN0_BER(i,:))
    mfprintf(fd_w,"%02.2f\t\t%.2E\t\t%d\t\t%d\t\t%02.2f\n", EsN0_BER(i,:));   
    i = i+1;
    EsN0dB = EsN0dB+EsN0dB_step;    
   end; // while
  mclose(fd_w);
  if run == 1
    EsN0_BER_avg = EsN0_BER;
  else
    EsN0_BER_avg = EsN0_BER_avg + EsN0_BER;
  end  
end
matFileNameX = matFileName+"_r00"+fileparts(perfConf.matFile,'extension')
fd_w = mopen( matFileNameX, 'wt');
EsN0_BER_avg = EsN0_BER_avg./runs;
[MatRow,MatCol]=size(EsN0_BER_avg);
for i=1:MatRow
  mfprintf(fd_w,"%02.2f\t\t%.2E\t\t%.2f\t\t%.2f\t\t%02.2f\n", EsN0_BER_avg(i,:));   
end
mclose(fd_w);  
exec("./app04ModClose.sci");

