//! FSK/MSK modem

clear;
clearglobal;
clc;
lines(0);
path=get_absolute_file_path("app04_main.sce")
chdir(path);
pwd
//---------------------------
$API="..\..\lib\sci_api1.sci";
dbg=0;
exec($API);  
//---------------------------
$FUNC="..\..\lib\sci_func1.sci";
exec($FUNC);  
//---------------------------
$FUN_SPEC="..\common\sci_spect1.sci";
exec($FUN_SPEC);  

exec(".\app04ModFunc.sci");

// GP variables
NULL=0;

// Fig 1,2,4
xdel(winsid());
exec("..\common\sci_fig4_1.sci");

// GetConfig
exec("..\common\sci_tk_getcfg_v1.sci");
confFilename = csim_tkgetconfig(".\conf\_default.cfg",".\conf")
[simConf,err] = loadSimConfig(confFilename);
disp(simConf);
exec(".\app04ModInit.sci");

// ---- TCL/TK set-up -----
// no noise
AWGN_FLAG = 0;
ber=[0, 0]; BER=[0,0];
BERT_LOCK_FLAG = %F;
BERT_CLEAR_FLAG = %F;
RMS1 = 0.0; RMS2 = 0.0; RMS3 = 0.0; RMS4 = 0.0; RMS5 = 0.0;
// Carier is 1.0 C^2=sqrtI^2+sqrtQ^2=2/2 
C_rms = 1.0;
// tk and global access variables
exec("./app04ModTk.sci");
exec("./app04ModGlob.sci");

N_opt1 = TCL_GetVar('Nopt');
N=floor(sscanf(N_opt1,"%d"));

// set delay timer unit
// realtimeinit(0.25); // timepass unit
realtimeinit(1);          // timepass unit
realtime(0);              // first call sets init time
time_up=0;
printf("Current time=\n");
printf("%d",time_up);

// Sim() Function
exec("./app04ModSim.sci");
// Disp() Function
exec("./app04ModDisp.sci");

// variables must exist to be set-up properly
button_state1=TCL_GetVar('button_state')
button_state2=button_state1;
FFT_RESET_FLAG = 1;
ph0 =0.0;
ip0 = 0.0;
global ph0 ip0;
// static - must be preserved outside scope of the SimApp function  
BER_bert = [0, 0];
BER_xor = [0, 0];
global winfft, BER_bert, BER_xor;

while (1==1)
    TCL_EvalStr('set h [winfo exists .app4]');
    if TCL_GetVar("h")=='0' then break, end    
    Update_TCLTK();
    if ( BERT_CLEAR_FLAG ) 
      SCI_EXEC(p_bert1, SCI_CLEAR);
      BER_xor=[0,0];  
      BERT_CLEAR_FLAG = %F;
      printf(" BER_bert BER_xor CLEARED\n");
    end    
    if (button_state1=='state_RUN') 
      // C_NdB=20*log(C_rms/N_rms)
      N_rms = (C_rms/ 10^(C_N/20));
      SCI_SET(p_wgn_x1, SCI_SIGMA, N_rms);
      SimApp();
      DispApp();  
    end; //   if (button_state1=='cont')
    time_up=time_up+1;
    realtime(time_up); // wait for next unit
    printf("\r%d",time_up);
end; //while (1==1)

csim_tcl_win_destroy();
TCL_EvalStr("catch { destroy  $::tkGetConf::win  }");
xdel(winsid());

exec("./app04ModClose.sci");
printf("\nEnd of operation\n");

