// ------------------------------------------
// old spectrum folding
function [ff,sf]=foldspect(f,s)
N=max(size(f));
for m=0:N-1,
    ff(m+1)=fs(modulo(N/2+m,N)+1);
    sf(m+1)=s(modulo(N/2+m,N)+1);
    if (ff(m+1)>=1/2)
      	ff(m+1)=ff(m+1)-1.0;
    end;
end;
endfunction;

// ------------------------------------------
// old spectrum calculation

function [fsf, sig, wsig, spect, avg_spect] = spectrum(p_fft_x, win, Navg, a_spect, xs)
    Nfft = max(size(win));
    n=[0:Nfft-1];
    fs=n.*(1/Nfft);
    if (Navg == 0)
        SCI_SET(p_fft_x, SCI_SIZE, Nfft);
        SCI_SET(p_fft_x, SCI_VEC, zeros(1:Nfft)+%i*zeros(1:Nfft));
    end;
    SCI_SET(p_fft_x, SCI_VEC, xs); // add xs[1:N]
    sig=SCI_GET(p_fft_x, SCI_PEEK_VEC); // get sig[1:Nfft]
    wsig = sig.*(win');
    xf=fft(wsig);
    sig_spect=abs(xf)*(1/Nfft);
    [fsf, spect]=foldspect(fs,sig_spect);
    if (Navg==0)
            avg_spect=spect;
    else
            c1=Navg/(Navg+1);
            c2=1/(Navg+1);
            avg_spect = c1*a_spect + c2*spect;
    end
    spect = spect + 1.0E-12;          // +eps for log
    avg_spect = avg_spect +1.0E-12;   // +eps for log
endfunction  
    
// ------------------------------------------
// struct_spect1 = struct('p_fft_x',p_fft_x1, 'Navg', 0, 'sig', zeros(1:N_FFT),...
//       'wsig', zeros(1:N_FFT), 'spect', %eps*ones(1:N_FFT), 'avg_spect', %eps*ones(1:N_FFT),...
//       'ff',zeros(1:N_FFT),'minff', -0.5, 'maxff', +0.5);
// HowTo - see: case_study2, case_study3, case_study4
//

function [struct_spect] = reset_spec(struct_spect, nfft, foldedfreq, freq0, zoom)
 
   SCI_SET(struct_spect.p_fft_x, SCI_SIZE, nfft); // reset size 
   // disp(SCI_GET(struct_spect.p_fft_x, SCI_SIZE));
   SCI_GET(struct_spect.p_fft_x, SCI_VEC); // purge
   // disp(SCI_GET(struct_spect.p_fft_x, SCI_N_OF_ELEM));
   struct_spect.Navg=0;
   struct_spect.Nfft= nfft,
   struct_spect.sig = zeros(1:nfft); 
   struct_spect.wsig = zeros(1:nfft); 
   struct_spect.spect = %eps*ones(1:nfft); 
   struct_spect.avg_spect = %eps*ones(1:nfft);
   // frequency scale - since in zoom it is in bb real frequency is at -freq0
   struct_spect.ff = (foldedfreq ./(2^zoom)) - freq0;
   struct_spect.minff = min(struct_spect.ff);
   struct_spect.maxff = max(struct_spect.ff);
endfunction


function [struct_spect] = calc_spec(struct_spect, winfft)
    // disp(SCI_GET(struct_spect.p_fft_x, SCI_N_OF_ELEM));
    if (SCI_GET(struct_spect.p_fft_x, SCI_N_OF_ELEM) == struct_spect.Nfft)
        struct_spect.sig = SCI_GET(struct_spect.p_fft_x, SCI_VEC);
        struct_spect.wsig = (struct_spect.sig).*(winfft');
        // local spectrum
        xf=fft(struct_spect.wsig);
        // fold spectrum
        xff=[xf(Nfft/2+1:Nfft)',xf(1:Nfft/2)'];
        // assign spectrum
        struct_spect.spect=abs(xff)*(1/Nfft) + %eps;
        Navg = struct_spect.Navg;
        if (Navg==0)
           struct_spect.avg_spect = struct_spect.spect;
        else
           struct_spect.avg_spect = Navg/(Navg+1)*struct_spect.avg_spect + 1/(Navg+1)*struct_spect.spect;
        end
        struct_spect.Navg=Navg+1;
    end
  
endfunction    
