## buttons.tcl
##
## demonstrates the simulation of a button array
##
## ellson@lucent.com
## modifications made by jeff at hobbs org

set ::VERSION 2.9
if {[string compare unix $tcl_platform(platform)]} {
    set table(library) Tktable$::VERSION[info sharedlibextension]
} else {
    set table(library) libTktable$::VERSION[info sharedlibextension]
}
if {
    [string match {} [info commands table]]
    && [catch {package require Tktable $::VERSION} err]
    && [catch {load [file join [pwd] $table(library)]} err]
    && [catch {load [file join [pwd] .. unix $table(library)]} err]
    && [catch {load [file join [pwd] .. win $table(library)]} err]
} {
    error $err
} else {
    puts "Tktable v[package provide Tktable] loaded"
}

array set table {
    rows    7
    cols    10
}

# create the table
#set t $table(table)
table .table -rows [expr {$table(rows)+1}] -cols [expr {$table(cols)+1}] \
    -titlerows  1 -titlecols  1 \
    -roworigin -1 -colorigin -1 \
    -colwidth 4 \
    -variable tab \
    -flashmode off \
    -cursor top_left_arrow \
    -borderwidth 2 \
    -state disabled

#   -xscrollcommand ".sx set" -yscrollcommand ".sy set"
#   -width 8 -height 8 \
#scrollbar .sx -orient h -command "$t xview"
#scrollbar .sy -orient v -command "$t yview"

#grid $t .sy -sticky nsew
#grid .sx -sticky ew
#grid columnconfig . 0 -weight 1
#grid rowconfig . 0 -weight 1

pack .table
# set up tags for the various states of the buttons
.table tag configure OFF -bg red -relief raised
.table tag configure ON  -bg green -relief sunken
.table tag configure sel -bg gray75 -relief flat
.table tag configure unsel -bg gray75 -relief flat

# clean up if mouse leaves the widget
bind .table <Leave> {
    %W selection clear all
}

# highlight the cell under the mouse
bind .table <Motion> {
    if {[%W selection includes @%x,%y]} break
    %W selection clear all
    %W selection set @%x,%y
    break
    ## "break" prevents the call to tkTableCheckBorder
}

# mousebutton 1 toggles the value of the cell
# use of "selection includes" would work here
bind .table <1> {
    set rc [%W cursel]
    if {[string match ON $tab($rc)]} {
    set tab($rc) OFF
        %W tag celltag OFF $rc
    } {
    set tab($rc) ON
        %W tag celltag ON $rc
    }
}

# inititialize the array, titles, and celltags
for {set i 0} {$i < $table(rows)} {incr i} {
    set tab($i,-1) $i
    for {set j 0} {$j < $table(cols)} {incr j} {
        if {! $i} {set tab(-1,$j) $j}
    set tab($i,$j) "OFF"
        .table tag celltag OFF $i,$j
    }
}

foreach i {4 5 6 7 8 9 } {
    .table tag celltag unsel 6,$i
    set tab(6,$i) ""
}
