# Scilab sets variables and then runs the script

if {! [info exist dbg_mode ]} {
    set sci_mode [llength [info commands ScilabEval]]
    set dbg_mode [expr ! $sci_mode ]
}

# ------------------------------------------------------
# variables for debug - standalone mode

if {$dbg_mode} {
console show
# this must be set by scilab
set C_Nmin 0.0
set C_Nmax 40.0
set C_N0 20.0
set AWGN_flag 0

set C_N $C_N0

}

# scilab needs a toplevel for this package to operate properly!!!
# set win .w2
catch {destroy .cn1}
toplevel .cn1

# this is controlled by slider C_N procedure
set C_N_txt [format "%1.3E" $C_N]

proc setC_N {slider} {

    global C_N
    global C_N_txt

    set C_N $slider
    set C_N_txt [format "%2.1f" $C_N]
    puts "slider=$slider C_N=$C_N ;  C_N_txt=$C_N_txt"
}



#------------ frame 0

    frame .cn1.frame0 -borderwidth 3
    pack .cn1.frame0 -side left

    label .cn1.frame0.labelC_N -text "C_NdB"
    grid .cn1.frame0.labelC_N -column 0 -row 1 -columnspan 1

    entry .cn1.frame0.entryC_N -width 15 -text "C_N" -textvariable C_N_txt
    grid .cn1.frame0.entryC_N -column 1 -row 1 -columnspan 2

    scale .cn1.frame0.scaleC_N -orient horizontal -length 250 \
    -from $C_Nmin  -to $C_Nmax  -resolution 0.1 -command "setC_N"
    .cn1.frame0.scaleC_N set $C_N0
    grid .cn1.frame0.scaleC_N -column 0 -row 3 -rowspan 3 -columnspan 3

    checkbutton .cn1.frame0.cb0 -text "AWGN"\
        -variable AWGN_flag -onvalue 1 -offvalue 0 -command  { puts "AWGN_flag=$AWGN_flag" }
    grid .cn1.frame0.cb0 -column 0 -row 7 -columnspan 1

    bind .cn1.frame0.entryC_N <KeyPress-Return>  {
    .cn1.frame0.scaleC_N set $C_N_txt
    setC_N $C_N_txt
   }



