# Scilab sets variables and then runs the script

if {! [info exist dbg_mode ]} {
    set sci_mode [llength [info commands ScilabEval]]
    set dbg_mode [expr ! $sci_mode ]
}

# ------------------------------------------------------
# variables for debug - standalone mode

if {$dbg_mode} {
console show
# this must be set by scilab
set C_Nmin 0.0
set C_Nmax 40.0
set C_N0 20.0
set AWGN_flag 0

}

# scilab needs a toplevel for this package to operate properly!!!

# set win .w2
catch {destroy .cn1}
toplevel .cn1




# this is controlled by slider C_N procedure
set C_N $C_N0
set C_N_txt [format "%1.3E" $C_N]

set SR ""
set BW ""
set EbNo ""

proc Update_EbNo {} {
  global C_N
  global SR
  global BW
  global EbNo

  puts "Update C_N=$C_N ; SR=$SR; BW=$BW"

  if  { ($SR !="") && ($SR >0) &&  ($BW !="") && ($BW >0)   } {
    set EbNo [format "%2.1f" [expr $C_N+10*log10($BW/$SR)]]
    }
}

proc setC_N {slider} {

    global C_N
    global C_N_txt

    set C_N $slider
    set C_N_txt [format "%2.1f" $C_N]
    puts "slider=$slider C_N=$C_N ;  C_N_txt=$C_N_txt"
    Update_EbNo
}

#------------ frame 0


    frame .cn1.frame0 -borderwidth 3
    pack .cn1.frame0 -side top

    #label .cn1.frame0.labelC_N -text "C_NdB"
    #grid .cn1.frame0.labelC_N -column 0 -row 1 -columnspan 1

    labelframe .cn1.frame0.l1 -text {SR}
    entry .cn1.frame0.l1.e1 -width 15  -textvariable SR
    pack .cn1.frame0.l1.e1 -fill x -expand 1 -padx 1 -pady 1

    labelframe .cn1.frame0.l2 -text {BW}
    entry .cn1.frame0.l2.e1 -width 15  -textvariable BW
    pack .cn1.frame0.l2.e1 -fill x -expand 1 -padx 1 -pady 1

    labelframe .cn1.frame0.l3 -text {C/N[dB]}
    entry .cn1.frame0.l3.e1 -width 15  -textvariable C_N_txt
    pack .cn1.frame0.l3.e1 -fill x -expand 1 -padx 1 -pady 1

    labelframe .cn1.frame0.l4 -text {Es/No[dB]}
    entry .cn1.frame0.l4.e1 -width 15  -textvariable EbNo
    pack .cn1.frame0.l4.e1 -fill x -expand 1 -padx 1 -pady 1

    grid .cn1.frame0.l1 -column 0 -row 0 -columnspan 1  -rowspan 1
    grid .cn1.frame0.l2 -column 1 -row 0 -columnspan 1  -rowspan 1
    grid .cn1.frame0.l3 -column 0 -row 1 -columnspan 1  -rowspan 1
    grid .cn1.frame0.l4 -column 1 -row 1 -columnspan 1  -rowspan 1

    frame .cn1.frame1 -borderwidth 3
    pack .cn1.frame1 -side bottom

    scale .cn1.frame1.scaleC_N -orient horizontal -length 250 \
    -from $C_Nmin  -to $C_Nmax  -resolution 0.1 -command "setC_N"
    .cn1.frame1.scaleC_N set $C_N0
    pack .cn1.frame1.scaleC_N

    checkbutton .cn1.frame1.cb0 -text "AWGN"\
        -variable AWGN_flag -onvalue 1 -offvalue 0 -command  { puts "AWGN_flag=$AWGN_flag" }
    pack .cn1.frame1.cb0


   bind .cn1.frame0.l1.e1 <KeyPress-Return>  {
   Update_EbNo }

   bind .cn1.frame0.l2.e1 <KeyPress-Return>  {
   Update_EbNo }

   bind .cn1.frame0.l3.e1 <KeyPress-Return>  {
   setC_N $C_N_txt
   .cn1.frame1.scaleC_N set $C_N_txt }


