# Scilab sets variables and then runs the script

if {! [info exist dbg_mode ]} {
    set sci_mode [llength [info commands ScilabEval]]
    set dbg_mode [expr ! $sci_mode ]
}

# ------------------------------------------------------
# variables for debug - standalone mode

if {$dbg_mode} {

console show
# this must be set by scilab
set fftwintype kais
set Nfft 1024
set REF_FFT  0.1
set REF_dB -30
set RANGE_dB  50
set FFT_LOG 1
}

# scilab needs a toplevel for this package to operate properly!!!

catch {destroy .fft1}
toplevel .fft1

	frame .fft1.f1 -borderwidth 10
	pack  .fft1.f1 -side left

	frame .fft1.f2 -borderwidth 10
	pack  .fft1.f2 -side right



    radiobutton .fft1.f1.r0 -text "Rect"	-variable fftwintype -value rect  -command { puts "fftwintype=$fftwintype" }
    radiobutton .fft1.f1.r1 -text "Tria"	-variable fftwintype -value tria  -command { puts "fftwintype=$fftwintype" }
    radiobutton .fft1.f1.r2 -text "Hamm"	-variable fftwintype -value hamm  -command { puts "fftwintype=$fftwintype" }
    radiobutton .fft1.f1.r3 -text "Hann" -variable fftwintype -value hann  -command { puts "fftwintype=$fftwintype" }
    radiobutton .fft1.f1.r4 -text "Kais" -variable fftwintype -value kais  -command { puts "fftwintype=$fftwintype" }

    pack .fft1.f1.r0 .fft1.f1.r1 .fft1.f1.r2 .fft1.f1.r3 .fft1.f1.r4 -anchor w


    radiobutton .fft1.f2.r0 -text "Nfft=4096"	-variable Nfft -value 4096  -command { puts "Nfft=$Nfft" }
    radiobutton .fft1.f2.r1 -text "Nfft=2048"	-variable Nfft -value 2048  -command { puts "Nfft=$Nfft" }
    radiobutton .fft1.f2.r2 -text "Nfft=1024"	-variable Nfft -value 1024  -command { puts "Nfft=$Nfft" }
    radiobutton .fft1.f2.r3 -text "Nfft= 512"	 -variable Nfft -value 512  -command { puts "Nfft=$Nfft" }

    pack .fft1.f2.r0 .fft1.f2.r1 .fft1.f2.r2 .fft1.f2.r3  -anchor w

    frame .fft1.f3 -borderwidth 10
    pack  .fft1.f3 -side right

    labelframe .fft1.f3.l1 -text {REF_FFT}
    entry .fft1.f3.l1.e -relief sunken -width 15 -textvariable REF_FFT
    pack .fft1.f3.l1.e -fill x -expand 1 -padx 1 -pady 1
    pack .fft1.f3.l1 -fill x -expand 1 -padx 1 -pady 1

    checkbutton .fft1.f3.b1 -text "FFT_LOG" -variable FFT_LOG -relief flat  -command { puts "FFT_LOG=$FFT_LOG" }
    pack .fft1.f3.b1 -side top -pady 2 -anchor w

    labelframe .fft1.f3.l2 -text {REF_dB}
    entry .fft1.f3.l2.e -relief sunken -width 15 -textvariable REF_dB
    pack .fft1.f3.l2.e -fill x -expand 1 -padx 1 -pady 1
    pack .fft1.f3.l2 -fill x -expand 1 -padx 1 -pady 1

    labelframe .fft1.f3.l3 -text {RANGE_dB}
    entry .fft1.f3.l3.e -relief sunken -width 15 -textvariable RANGE_dB
    pack .fft1.f3.l3.e -fill x -expand 1 -padx 1 -pady 1
    pack .fft1.f3.l3 -fill x -expand 1 -padx 1 -pady 1




