# Scilab sets variables and then runs the script

if {! [info exist dbg_mode ]} {
    set sci_mode [llength [info commands ScilabEval]]
    set dbg_mode [expr ! $sci_mode ]
}

# ------------------------------------------------------
# variables for debug - standalone mode

if {$dbg_mode} {
console show
# this must be set by scilab
set PMmin 10.0
set PMmax 40.0
set PM0 20.0
set PM_flag 0

set PM $PM0

}

# scilab needs a toplevel for this package to operate properly!!!

# set win .w2
catch {destroy .pm1}
toplevel .pm1




# this is controlled by slider P_M procedure
set PM_txt [format "%1.3E" $PM]

proc setPM {slider} {

    global PM
    global PM_txt

    set PM $slider
    set PM_txt [format "%2.1f" $PM]
    puts "slider=$slider PM=$PM ;  PM_txt=$PM_txt"
}



#------------ frame 0

    frame .pm1.frame0 -borderwidth 3
    pack .pm1.frame0 -side left

    label .pm1.frame0.labelPM -text "PMdB"
    grid .pm1.frame0.labelPM -column 0 -row 1 -columnspan 1

    entry .pm1.frame0.entryPM -width 15 -text "PM" -textvariable PM_txt
    grid .pm1.frame0.entryPM -column 1 -row 1 -columnspan 2

    scale .pm1.frame0.scalePM -orient horizontal -length 250 \
    -from $PMmin  -to $PMmax  -resolution 0.1   -command "setPM"
    .pm1.frame0.scalePM set $PM0
    grid .pm1.frame0.scalePM -column 0 -row 3 -rowspan 3 -columnspan 3

    checkbutton .pm1.frame0.cb0 -text "PM"\
        -variable PM_flag -onvalue 1 -offvalue 0 -command  { puts "PM_flag=$PM_flag" }
    grid .pm1.frame0.cb0 -column 0 -row 7 -columnspan 1



