# Scilab sets variables and then runs the script
# scilab _variables sets themselves when executed without Scilab

if {! [info exist dbg_mode ]} {
    set sci_mode [llength [info commands ScilabEval]]
    set dbg_mode [expr ! $sci_mode ]
}

# ------------------------------------------------------
# variables for debug - standalone mode

if {$dbg_mode} {
console show
# this must be set by scilab
set RMS1 1.000000
set RMS2 0.1
set RMS3 0.05

set NBW [format "%2.1f" [expr ($RMS3*$RMS3)/($RMS2*$RMS2)]]
set SNR [format "%2.1f" [expr 20*log($RMS1/$RMS3)]]

}

# scilab needs a toplevel for this package to operate properly!!!

#set win .w5
catch {destroy .rms1}
toplevel .rms1


#------------ frame 1
    frame .rms1.frame1 -borderwidth 1
    pack  .rms1.frame1 -side left

    labelframe .rms1.frame1.l1 -text {RMS1=S}
    entry .rms1.frame1.l1.e -relief sunken -width 15 -textvariable RMS1
    pack .rms1.frame1.l1.e -fill x -expand 1 -padx 1 -pady 1

    labelframe .rms1.frame1.l2 -text {RMS2=N}
    entry .rms1.frame1.l2.e -relief sunken -width 15 -textvariable RMS2
    pack .rms1.frame1.l2.e -fill x -expand 1 -padx 1 -pady 1

    labelframe .rms1.frame1.l3 -text {RMS3=Nf}
    entry .rms1.frame1.l3.e -relief sunken -width 15 -textvariable RMS3
    pack .rms1.frame1.l3.e -fill x -expand 1 -padx 1 -pady 1

    labelframe .rms1.frame1.l4 -text {NBW=Nf^2/N^2}
    entry .rms1.frame1.l4.e -relief sunken -width 15 -textvariable NBW
    pack .rms1.frame1.l4.e -fill x -expand 1 -padx 1 -pady 1

    labelframe .rms1.frame1.l5 -text {SNR=20lg(S/Nf)}
    entry .rms1.frame1.l5.e -relief sunken -width 15 -textvariable SNR
    pack .rms1.frame1.l5.e -fill x -expand 1 -padx 1 -pady 1


    pack .rms1.frame1.l1 .rms1.frame1.l2  .rms1.frame1.l3  .rms1.frame1.l4 .rms1.frame1.l5 -padx 3  -pady 1

