# Scilab sets variables and then runs the script

if {! [info exist dbg_mode ]} {
    set sci_mode [llength [info commands ScilabEval]]
    set dbg_mode [expr ! $sci_mode ]
}

# ------------------------------------------------------
# variables for debug - standalone mode

if {$dbg_mode} {
console show
# this must be set by scilab
set SYMmin 0
set SYMmax 3
set SYM0 1
set SYM $SYM0

}

# scilab needs a toplevel for this package to operate properly!!!

# set win .w2
catch {destroy .sym1}
toplevel .sym1




# this is controlled by slider P_M procedure  - scilab sends doubles
set SYM_txt [format "%1.0f" $SYM]

proc setSYM {slider} {

    global SYM
    global SYM_txt

    set SYM $slider
#  scilab sends doubles
    set SYM_txt [format "%1.0f" $SYM]
    puts "slider=$slider SYM=$SYM ;  SYM_txt=$SYM_txt"
}



#------------ frame 0

    frame .sym1.frame0 -borderwidth 3
    pack .sym1.frame0 -side left

    label .sym1.frame0.labelSYM -text "SYMdB"
    grid .sym1.frame0.labelSYM -column 0 -row 1 -columnspan 1

    entry .sym1.frame0.entrySYM -width 15 -text "SYM" -textvariable SYM_txt
    grid .sym1.frame0.entrySYM -column 1 -row 1 -columnspan 2

    scale .sym1.frame0.scaleSYM -orient horizontal -length 250 \
    -from $SYMmin  -to $SYMmax  -resolution 1   -command "setSYM"
    .sym1.frame0.scaleSYM set $SYM0
    grid .sym1.frame0.scaleSYM -column 0 -row 3 -rowspan 3 -columnspan 3




