//! test scicoslab_itpp with fir_x 
path=get_absolute_file_path("sci_fir_x1.sce");
chdir(path);
pwd;
//---------------------------
if (~ exists('ITPP_SCI_LIB'))
  clear;
  clc;
  lines(0);
  dbg=0;
  exec("..\..\lib\sci_api1.sci");
  exec("..\..\lib\sci_func1.sci");  
end
//---------------------------

TAPS = 5;
N=10;
i=1:N;
c0=(ones(TAPS,1)+%i*ones(TAPS,1))*0.1;
x=zeros(N,1)+%i*zeros(N,1);
x(1,1)=1.0+%i*0.0;
ce(1:N,1)=%t;

p_firx1=SCI_CREATE(SCI_FIR_X);
sci_type = SCI_GET(p_firx1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_FIR_X, "type != SCI_FIR_X");

SCI_SET(p_firx1,SCI_TAPS,c0);
SCI_EXEC(p_firx1,SCI_RESET);

c1=SCI_GET(p_firx1,SCI_TAPS);
z1=SCI_GET(p_firx1,SCI_STATE);
itpp_sci_assert(c1 == c0, "c1 != c0");
itpp_sci_assert(z1 == (zeros(TAPS,1) + %i*zeros(TAPS,1)), "z1 != zeros(TAPS)");

y=SCI_PROC(p_firx1,ce,x);
yref = [c0; (zeros(N - TAPS,1) + %i*zeros(N - TAPS,1))];
itpp_sci_assert(y == yref, "y != yref");

SCI_DESTROY(p_firx1);

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
    ulink(id);
    printf('So, this is it \n');
end
//---------------------------
