//! test scicoslab_itpp with lfsr 
path=get_absolute_file_path("sci_lfsr1.sce");
chdir(path);
pwd;
//---------------------------
if (~ exists('ITPP_SCI_LIB'))
  clear;
  clc;
  lines(0);
  dbg=0;
  exec("..\..\lib\sci_api1.sci");
  exec("..\..\lib\sci_func1.sci");  
end
//---------------------------
// J.83B standard - PRBS randomizer
//                1+   X3+X4
//                0 1 2 3 4	
c0 = to_bvec([1 0 0 1 1]);
L = max(size(c0))-1;
M = (2^L)-1;  // prbs sequence lenght
W = M;       // symbol size == prbs sequence

p_lfsr1 = SCI_CREATE(SCI_LFSR);
sci_type = SCI_GET(p_lfsr1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_LFSR, "sci_type != SCI_LFSR");

//  minimal setup set_taps()/prbs() and set_symbol_size()
SCI_SET(p_lfsr1, SCI_POLY, c0);
SCI_SET(p_lfsr1, SCI_SYMBOL_SIZE, W);

c1 = SCI_GET(p_lfsr1, SCI_POLY);
itpp_sci_assert(c1 == c0, "c1 != c0");

reverse_flag = SCI_GET(p_lfsr1, SCI_REVERSE_FLAG);
itpp_sci_assert(reverse_flag, "reverse_flag != true");

z0 = to_bvec(zeros(L));
z0(L) = %T;    
z1 = SCI_GET(p_lfsr1, SCI_STATE);
itpp_sci_assert(z1 == z0, "z1 != z0");

W1 = SCI_GET(p_lfsr1, SCI_SYMBOL_SIZE); 
itpp_sci_assert(W1 == W, "W1 != W");

    // number of ticks == number of symbols
N = 4;
ce(1:N) = %T;
yref1 = to_bmat(zeros(N,W));
for i = 1:N
     yref1(i,:) = to_bvec(reverse_row([0 0 1 1 0 1 0 1 1 1 1 0 0 0 1])).';
end
y1 = SCI_GEN(p_lfsr1, ce);
itpp_sci_assert(y1 == yref1, "y != yref");

SCI_SET(p_lfsr1, SCI_REVERSE_FLAG, %F);
reverse_flag = SCI_GET(p_lfsr1, SCI_REVERSE_FLAG);
itpp_sci_assert(~reverse_flag, "reverse_flag != false");

yref2 = to_bmat(zeros(N,W));
for i = 1:N
     yref2(i,:) = to_bvec([0 0 1 1 0 1 0 1 1 1 1 0 0 0 1]).';
end
y2 = SCI_GEN(p_lfsr1, ce);
itpp_sci_assert(y2 == yref2, "y != yref");

SCI_DESTROY(p_lfsr1);
		
//---------------------------
if (~ exists('ITPP_SCI_LIB'))
    ulink(id);
    printf('So, this is it \n');
end
//---------------------------
