//! test c_sci fir interface
path=get_absolute_file_path("sci_counter1.sce");
chdir(path);
pwd

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
  clear;
  clc;
  lines(0);
  dbg=0;
  exec("..\..\lib\sci_api1.sci");
  exec("..\..\lib\sci_func1.sci");  
end
//---------------------------

N = 4;
M = N*4;
p_cnt1 = SCI_CREATE(SCI_COUNTER);
sci_type = SCI_GET(p_cnt1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_COUNTER, "sci_type != SCI_COUNTER");

// modulo
SCI_SET(p_cnt1, SCI_PARAM_N, N);
itpp_sci_assert(N ==  SCI_GET(p_cnt1, SCI_PARAM_N) , "N != get_N()");
ce(1:M,1) = %T;
yref(1:M,1) = %F;
c0 = 0;
for i=1:M
    c0 = c0 + 1;
    if (c0 == N)
        c0 = 0;
        yref(i,1) = %T;
     end   
end
y = SCI_GEN(p_cnt1, ce);
itpp_sci_assert(y == yref, "y != yref");

c0 = SCI_GET(p_cnt1, SCI_STATE);
itpp_sci_assert(c0 == 0, "c0 != 0");

SCI_SET(p_cnt1, SCI_STATE, N - 1); 
c0 = SCI_GET(p_cnt1, SCI_STATE);
itpp_sci_assert(c0 == N - 1, "c0 != N-1");

SCI_EXEC(p_cnt1, SCI_RESET);
c0 = SCI_GET(p_cnt1, SCI_STATE);
itpp_sci_assert(c0 == 0, "c0 != 0");

SCI_DESTROY(p_cnt1);

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
    ulink(id);
    printf('So, this is it \n');
end
//---------------------------


