//!  test scicoslab_itpp with int2bin, bin2int
//---------------------------

path=get_absolute_file_path("sci_bin2int1.sce");
chdir(path);
pwd
//---------------------------
if (~ exists('ITPP_SCI_LIB'))
  clear;
  clc;
  lines(0);
  dbg=0;
  exec("..\..\lib\sci_api1.sci");
  exec("..\..\lib\sci_func1.sci");  
end
//---------------------------


	
N=16;	
W=4;
ce(1:N,1)=%T;

x1=int32(linspace(0,N-1,N)');


p_i2b1 = SCI_CREATE(SCI_INT2BIN);
sci_type = SCI_GET(p_i2b1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_INT2BIN, "sci_type != SCI_INT2BIN");

p_b2i1 = SCI_CREATE(SCI_BIN2INT);
sci_type = SCI_GET(p_b2i1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_BIN2INT, "sci_type != SCI_BIN2INT");

SCI_SET(p_i2b1, SCI_SYMBOL_SIZE, W);
SCI_SET(p_b2i1, SCI_SYMBOL_SIZE, W);

itpp_sci_assert(W == SCI_GET(p_i2b1, SCI_SYMBOL_SIZE), "W != SCI_GET(p_i2b1, SCI_SYMBOL_SIZE)");
itpp_sci_assert(W == SCI_GET(p_b2i1, SCI_SYMBOL_SIZE), "W != SCI_GET(p_b2i1, SCI_SYMBOL_SIZE)");
itpp_sci_assert(SCI_GET(p_i2b1, SCI_MSB_FLAG), "true != SCI_GET(p_i2b1, SCI_MSB_FLAG)");
itpp_sci_assert(SCI_GET(p_b2i1, SCI_MSB_FLAG), "true != SCI_GET(p_b2i1, SCI_MSB_FLAG)");

y1_ref = to_bmat([0 0 0 0; 0 0 0 1; 0 0 1 0; 0 0 1 1; 0 1 0 0; 0 1 0 1; 0 1 1 0; 0 1 1 1;...
                  1 0 0 0; 1 0 0 1; 1 0 1 0; 1 0 1 1; 1 1 0 0; 1 1 0 1; 1 1 1 0; 1 1 1 1]);

y1 = SCI_PROC(p_i2b1, ce, x1);
itpp_sci_assert(y1 == y1_ref, "y1 != y1_ref");

y2 = SCI_PROC(p_b2i1, ce, y1);
itpp_sci_assert(y2 == x1, "y2 != x1");

SCI_SET(p_i2b1, SCI_MSB_FLAG, %F);
SCI_SET(p_b2i1, SCI_MSB_FLAG, %F);
itpp_sci_assert(~SCI_GET(p_i2b1, SCI_MSB_FLAG), "true = SCI_GET(p_i2b1, SCI_MSB_FLAG)");
itpp_sci_assert(~SCI_GET(p_b2i1, SCI_MSB_FLAG), "true = SCI_GET(p_b2i1, SCI_MSB_FLAG)");
itpp_sci_assert(W == SCI_GET(p_i2b1, SCI_SYMBOL_SIZE), "W != SCI_GET(p_i2b1, SCI_SYMBOL_SIZE)");
itpp_sci_assert(W == SCI_GET(p_b2i1, SCI_SYMBOL_SIZE), "W != SCI_GET(p_b2i1, SCI_SYMBOL_SIZE)");

y1_ref = reverse_row(y1_ref);

y1 = SCI_PROC(p_i2b1, ce, x1);
itpp_sci_assert(y1 == y1_ref, "y1 != y1_ref");

y2 = SCI_PROC(p_b2i1, ce, y1);
itpp_sci_assert(y2 == x1, "y2 != x1");
       
SCI_DESTROY(p_i2b1);
SCI_DESTROY(p_b2i1);


//---------------------------
if (~ exists('ITPP_SCI_LIB'))
    ulink(id);
    printf('So, this is it \n');
end
//---------------------------

