//!  test scilab_itpp with rms, rms_x
//---------------------------

path=get_absolute_file_path("sci_rms1.sce");
chdir(path);
pwd
//---------------------------
if (~ exists('ITPP_SCI_LIB'))
  clear;
  clc;
  lines(0);
  dbg=0;
  exec("..\..\lib\sci_api1.sci");
  exec("..\..\lib\sci_func1.sci");  
end
//---------------------------

MAV = 10;   // mav lenght	
N = 20;     // sequence lenght
epsilon = 1.0E-5;

p_rms1 = SCI_CREATE(SCI_RMS);
sci_type = SCI_GET(p_rms1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_RMS, "sci_type != SCI_RMS");

p_rms_x1 = SCI_CREATE(SCI_RMS_X);
sci_type = SCI_GET(p_rms_x1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_RMS_X, "sci_type != SCI_RMS_X");

ce(1:N,1) = %T;
true_vec(1:N,1) = %T;
x1 = ones(1:N);
x_x1 = x1+%i*x1; // (1.0+j1.0)	

SCI_SET(p_rms1,SCI_SIZE,MAV);	
itpp_sci_assert(SCI_GET(p_rms1, SCI_SIZE) == MAV, "rms1.size !=MAV");
SCI_SET(p_rms_x1, SCI_SIZE, MAV);
itpp_sci_assert(SCI_GET(p_rms_x1, SCI_SIZE) == MAV, "rms_x1.size !=MAV");

//       sqrt(MAV 1.0 step response)
//       sqrt(0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.0 1.0......)
y1_ref = ([0.31623 0.44721 0.54772 0.63246 0.70711 0.77460 0.83666 0.89443 0.94868 ...
          1.00000 1.00000 1.00000 1.00000 1.00000 1.00000 1.00000 1.00000 1.00000 1.00000 1.00000]).';
y1 = SCI_PROC(p_rms1, ce, x1);
itpp_sci_assert((abs(y1 - y1_ref) < epsilon) == true_vec, "abs(y1 - y1_ref) > epsilon ");

//   sqrt(MAV sqrt(2) step response)
//   sqrt(2)*sqrt(0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.0 1.0......)
y_x1_ref = ([0.44721 0.63246 0.77460 0.89443 1.00000 1.09545 1.18322 1.26491 1.34164 ...
             1.41421 1.41421 1.41421 1.41421 1.41421 1.41421 1.41421 1.41421 1.41421 1.41421 1.41421]).';
y_x1 = SCI_PROC(p_rms_x1, ce, x_x1);
itpp_sci_assert((abs(y_x1 - y_x1_ref) < epsilon) == true_vec, "abs(y_x1 - y_x1_ref) > epsilon ");

SCI_DESTROY(p_rms1);
SCI_DESTROY(p_rms_x1);

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
    ulink(id);
    printf('So, this is it \n');
end
//---------------------------

