//!  test scilab_itpp with rms, rms_x
//---------------------------

path=get_absolute_file_path("sci_wgn1.sce");
chdir(path);
pwd
//---------------------------
if (~ exists('ITPP_SCI_LIB'))
  clear;
  clc;
  lines(0);
  dbg=0;
  exec("..\..\lib\sci_api1.sci");
  exec("..\..\lib\sci_func1.sci");  
end
//---------------------------

// scilab function - variance for complex vector
// library function gives complex value which is silly, or not
// read wikipeda variance, where variance for complex variable
// https://en.wikipedia.org/wiki/Variance#Generalizations
// note, that vector X in wiki means - N dimentional variable
function v = cvar(X)
    m = mean(X);
    x = X-m;
    v = mean (abs(x).^2);    
endfunction

// assume that real, imag are uncorrelated...
function v = cvar_x(X)
    sr = stdev(real(X));
    si = stdev(imag(X));    
    v = sr^2+ si^2;    
endfunction

sigma_x1_ref = 0.1;
mean_x1_ref = 0.2;
sigma_x_x1_ref = 0.15;
mean_x_x1_ref = 0.25 -%i*0.25;
epsilon = 3.0E-1; // 30 %

N = 1000;      // sequence lenght
ce(1:N,1) = %T;

p_wgn1 = SCI_CREATE(SCI_WGN);
sci_type = SCI_GET(p_wgn1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_WGN, "sci_type != SCI_WGN");
SCI_SET(p_wgn1, SCI_SIGMA, sigma_x1_ref);
itpp_sci_assert(SCI_GET(p_wgn1, SCI_SIGMA) == sigma_x1_ref, "wgn1.get_sigma() != sigma_x1_ref");
SCI_SET(p_wgn1, SCI_MEAN, mean_x1_ref);
itpp_sci_assert(SCI_GET(p_wgn1, SCI_MEAN) == mean_x1_ref, "wgn1.get_mean() != mean_x1_ref");

p_wgn_x1 = SCI_CREATE(SCI_WGN_X);
sci_type = SCI_GET(p_wgn_x1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_WGN_X, "sci_type != SCI_WGN_X");
SCI_SET(p_wgn_x1, SCI_SIGMA, sigma_x_x1_ref);
itpp_sci_assert(SCI_GET(p_wgn_x1, SCI_SIGMA) == sigma_x_x1_ref, "wgn_x1.get_sigma() != sigma_x1_ref");
SCI_SET(p_wgn_x1, SCI_MEAN, mean_x_x1_ref);
itpp_sci_assert(SCI_GET(p_wgn_x1, SCI_MEAN) == mean_x_x1_ref, "wgn_x1.get_mean() != mean_x_x1_ref");

x1 = SCI_GEN(p_wgn1,ce);
mean_x1 = mean(x1);
if (mean_x1_ref <> 0.0)
  itpp_sci_assert(abs((mean_x1 - mean_x1_ref) / mean_x1_ref) < epsilon, "abs((mean_x1 - mean_x1_ref) / mean_x1_ref) > epsilon");
end
// variance = E[(X-m)^2] = E[x^2] | X=x+m
sigma_x1 = sqrt(variance(x1));
itpp_sci_assert((sigma_x1 - sigma_x1_ref) < epsilon*sigma_x1_ref, "(sigma_x1 - sigma_x1_ref)/sigma_x1_ref > epsilon*sigma_x1_ref");

x_x1 = SCI_GEN(p_wgn_x1, ce);
mean_x_x1 = mean(x_x1);
if (abs(mean_x_x1_ref) <> 0.0)
  itpp_sci_assert((abs(mean_x1) - abs(mean_x1_ref)) / abs(mean_x1_ref) < epsilon, "abs((abs(mean_x1) - abs(mean_x1_ref)) / abs(mean_x1_ref) > epsilon");
end
// variance = E[(X-m)*(conj(X)-conj(m))] = E[x*conj(x)] | X=x+m
// sigma_x_x1 = sqrt(variance(x_x1));
sigma_x_x1 = sqrt(cvar(x_x1));
itpp_sci_assert((sigma_x_x1 - sigma_x_x1_ref) < epsilon*sigma_x_x1_ref, "(sigma_x_x1 - sigma_x_x1_ref)/sigma_x_x1_ref > epsilon*sigma_x1_ref");

SCI_DESTROY(p_wgn1);
SCI_DESTROY(p_wgn_x1);

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
    ulink(id);
    printf('So, this is it \n');
end
//---------------------------
        
