//!  test scilab_itpp with fir_up, fir_up_x
//---------------------------
path=get_absolute_file_path("sci_fir_up1.sce");
chdir(path);
pwd;
//---------------------------
if (~ exists('ITPP_SCI_LIB'))
  clear;
  clc;
  lines(0);
  dbg=0;
  exec("..\..\lib\sci_api1.sci");
  exec("..\..\lib\sci_func1.sci");  
end
//---------------------------

TAPS = 8;
N = 2 * TAPS;

// counter generates cei|ceo
p_cnt1 = SCI_CREATE(SCI_COUNTER);		
SCI_SET(p_cnt1, SCI_PARAM_N, TAPS);
SCI_SET(p_cnt1, SCI_STATE, TAPS - 1);
ceo(1:N,1)=%T;
cei = SCI_GEN(p_cnt1, ceo); 
ce=[cei,ceo];

// fir_up filter is MAV	 
c0 = ones(TAPS,1)*(1.0 / TAPS);
p_fir_up1 = SCI_CREATE(SCI_FIR_UP);
sci_type = SCI_GET(p_fir_up1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_FIR_UP, "sci_type != SCI_FIR_UP");
SCI_SET(p_fir_up1, SCI_TAPS, c0);
SCI_EXEC(p_fir_up1, SCI_RESET);
c1 = SCI_GET(p_fir_up1, SCI_TAPS);
z1 = SCI_GET(p_fir_up1, SCI_STATE);
itpp_sci_assert(c1 == c0, "c1 != c0");
itpp_sci_assert(z1 == zeros(TAPS), "z1 != zeros(TAPS)");

// set up input signal
x(1:N,1)=1.0;
// process
y = SCI_PROC(p_fir_up1, ce, x);
//  y should be constant signal 
y_ref = ones(N)*(1.0 / TAPS);
itpp_sci_assert(y == y_ref, "y != y_ref");


// fir_up_x filter is complex MAV 
c_x0 = c0 + %i*c0;
p_fir_up_x1 = SCI_CREATE(SCI_FIR_UP_X);
sci_type = SCI_GET(p_fir_up_x1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_FIR_UP_X, "sci_type != SCI_FIR_UP_X");

SCI_SET(p_fir_up_x1, SCI_TAPS, c_x0);
SCI_EXEC(p_fir_up_x1, SCI_RESET);
c_x1 = SCI_GET(p_fir_up_x1, SCI_TAPS);
z_x = SCI_GET(p_fir_up_x1, SCI_STATE);

itpp_sci_assert(c_x1 == c_x0, "c_x1 != c_x0");
itpp_sci_assert(z_x == to_cvec(zeros(TAPS), zeros(TAPS)), "z_x != zeros(TAPS)");

// set up input signal
x_x(1:N,1)=1.0 + %i*0.0;
// process
y_x = SCI_PROC(p_fir_up_x1, ce, x_x);
//  y should be constant complex signal 
y_x_ref = (ones(N)+%i*ones(N))*(1.0 / TAPS);
itpp_sci_assert(y_x == y_x_ref, "y_x != y_x_ref");
	
SCI_DESTROY(p_cnt1);
SCI_DESTROY(p_fir_up1);
SCI_DESTROY(p_fir_up_x1);

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
    ulink(id);
    printf('So, this is it \n');
end
//---------------------------

