//! test itpp_sci amp, amp_x interface
//---------------------------

path=get_absolute_file_path("sci_amp_x1.sce");
chdir(path);
pwd;

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
  clear;
  clc;
  lines(0);
  dbg=0;
  exec("..\..\lib\sci_api1.sci");
  exec("..\..\lib\sci_func1.sci");  
end
//---------------------------

format('v',6);

N = 10;      // sequence lenght
g1_gain = 1.1;
g1_offset = 0.1;
g_x1_gain = 1.15 +%i*1.25;
g_x1_offset = 0.15+%i*0.25;
epsilon = 1.0E-6;

p_wgn1 = SCI_CREATE(SCI_WGN); 
p_wgn_x1 = SCI_CREATE(SCI_WGN_X);

p_g1 = SCI_CREATE(SCI_AMP);
sci_type = SCI_GET(p_g1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_AMP, "sci_type != SCI_AMP");

SCI_SET(p_g1, SCI_GAIN, g1_gain);
SCI_SET(p_g1, SCI_OFFSET, g1_offset);

itpp_sci_assert(SCI_GET(p_g1, SCI_GAIN) == g1_gain, "g1.get_gain() != g1_gain");
itpp_sci_assert(SCI_GET(p_g1, SCI_OFFSET) == g1_offset, "g1.get_offset() != g1_offset");

p_g_x1 = SCI_CREATE(SCI_AMP_X);
sci_type = SCI_GET(p_g_x1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_AMP_X, "sci_type != SCI_AMP_X");

SCI_SET(p_g_x1, SCI_GAIN, g_x1_gain);
SCI_SET(p_g_x1, SCI_OFFSET, g_x1_offset);

itpp_sci_assert(SCI_GET(p_g_x1, SCI_GAIN) == g_x1_gain, "g_x1.get_gain() != g_x1_gain");
itpp_sci_assert(SCI_GET(p_g_x1, SCI_OFFSET) == g_x1_offset, "g_x1.get_offset() != g_x1_offset");

ce(1:N,1)=%T;
true_vec(1:N,1) = %T;

x1 = SCI_GEN(p_wgn1, ce);
x_x1 = SCI_GEN(p_wgn_x1, ce);

y1 = SCI_PROC(p_g1, ce, x1);
y1_ref = g1_gain*x1 + g1_offset;

y_x1 = SCI_PROC(p_g_x1, ce, x_x1);
y_x1_ref = g_x1_gain*x_x1 + g_x1_offset;

itpp_sci_assert((abs(y1 - y1_ref) < epsilon) == true_vec, "abs(y1 - y1_ref) > epsilon");
itpp_sci_assert((abs(real(y_x1) - real(y_x1_ref)) < epsilon) == true_vec, "abs(real(y_x1) - real(y_x1_ref) > epsilon ");
itpp_sci_assert((abs(imag(y_x1) - imag(y_x1_ref)) < epsilon) == true_vec, "abs(imag(y_x1) - imag(y_x1_ref) > epsilon ");


SCI_DESTROY(p_wgn1);
SCI_DESTROY(p_wgn_x1);
SCI_DESTROY(p_g1);
SCI_DESTROY(p_g_x1);

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
    ulink(id);
    printf('So, this is it \n');
end
//---------------------------
