//! test itpp_sci interface
path=get_absolute_file_path("sci_mix_x1.sce");
chdir(path);
pwd;

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
  clear;
  clc;
  lines(0);
  dbg=0;
  exec("..\..\lib\sci_api1.sci");
  exec("..\..\lib\sci_func1.sci");  
end
//---------------------------

format('v',6);

N=10;	
epsilon = 1.0E-6;

p_wgn1 = SCI_CREATE(SCI_WGN); 
p_wgn_x1 = SCI_CREATE(SCI_WGN_X);

p_mix1 = SCI_CREATE(SCI_MIX);
sci_type = SCI_GET(p_mix1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_MIX, "mix1.sci_type != SCI_MIX");

p_mix_x1 = SCI_CREATE(SCI_MIX_X);
sci_type = SCI_GET(p_mix_x1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_MIX_X, "mix_x1.sci_type != SCI_MIX_X");


ce(1:N,1)=%T;
true_vec(1:N,1) = %T;

x1 = SCI_GEN(p_wgn1, ce);
x2 = SCI_GEN(p_wgn1, ce);
x(1:N,1) = x1;
x(1:N,2) = x2;
y = SCI_PROC(p_mix1, ce, x);
y_ref = x1 .* x2;

x_x1 = SCI_GEN(p_wgn_x1, ce);
x_x2 = SCI_GEN(p_wgn_x1, ce);
x_x(1:N,1) = x_x1;
x_x(1:N,2) = x_x2;
y_x = SCI_PROC(p_mix_x1, ce, x_x);
y_x_ref = x_x1 .* x_x2;

itpp_sci_assert((abs(y - y_ref) < epsilon) == true_vec, "abs(y - y_ref) > epsilon");
itpp_sci_assert((abs(real(y_x) - real(y_x_ref)) < epsilon) == true_vec, "abs(real(y_x) - real(y_x_ref) > epsilon ");
itpp_sci_assert((abs(imag(y_x) - imag(y_x_ref)) < epsilon) == true_vec, "abs(imag(y_x) - imag(y_x_ref) > epsilon ");

SCI_DESTROY(p_wgn1);
SCI_DESTROY(p_wgn_x1);
SCI_DESTROY(p_mix1);
SCI_DESTROY(p_mix_x1);

format('v',10);
//---------------------------
if (~ exists('ITPP_SCI_LIB'))
    ulink(id);
    printf('So, this is it \n');
end
//---------------------------
