//! test itpp_sci iq2ap, ap2iq interface
//---------------------------

path=get_absolute_file_path("sci_iq2ap1.sce");
chdir(path);
pwd;

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
  clear;
  clc;
  lines(0);
  dbg=0;
  exec("..\..\lib\sci_api1.sci");
  exec("..\..\lib\sci_func1.sci");  
end
//---------------------------

format('v',6);

M = 16;
ce(1:M,1) = %T;
true_vec(1:M,1) = %T;
ivx = (linspace(0,M-1,M))';
epsilon = 1.0E-6;

p_qmod1 = SCI_CREATE(SCI_QAM_MOD);
p_qdem1 = SCI_CREATE(SCI_QAM_DEM);
SCI_SET(p_qmod1, SCI_SIZE, M);
SCI_SET(p_qdem1, SCI_SIZE, M);

p_iq2ap1 = SCI_CREATE(SCI_IQ2AP);
sci_type = SCI_GET(p_iq2ap1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_IQ2AP, "sci_type != SCI_IQ2AP");

p_ap2iq1 = SCI_CREATE(SCI_AP2IQ);
sci_type = SCI_GET(p_ap2iq1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_AP2IQ, "sci_type != SCI_IQ2AP");

cv =  SCI_PROC(p_qmod1, ce, ivx);
ap =  SCI_PROC(p_iq2ap1, ce, cv);
iq =  SCI_PROC(p_ap2iq1, ce, ap);
ivy = SCI_PROC(p_qdem1, ce, iq); 

y = [ivx, double(ivy), cv, iq, ap(:,1), ap(:,2)];
itpp_sci_assert(ivx == ivy, "ivx!=ivy");
itpp_sci_assert((abs(cv - iq) < epsilon) == true_vec, "cv!=iq");

SCI_DESTROY(p_qmod1);
SCI_DESTROY(p_qdem1);
SCI_DESTROY(p_iq2ap1);         
SCI_DESTROY(p_ap2iq1);

format('v',10);
        
//---------------------------
if (~ exists('ITPP_SCI_LIB'))
    ulink(id);
    printf('So, this is it \n');
end
//---------------------------
