//! test itpp_sci interface
//---------------------------

path=get_absolute_file_path("sci_psk1.sce");
chdir(path);
pwd;

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
  clear;
  clc;
  lines(0);
  dbg=0;
  exec("..\..\lib\sci_api1.sci");
  exec("..\..\lib\sci_func1.sci");  
end
//---------------------------

epsilon = 1.0E-6;
M = 8;

ivx = (linspace(0, M-1, M)).'; // column vectors are returned by itpp_sci
cv_ref = [0.7071068+%i*0.0000000; 0.5000000+%i*0.5000000; 0.0000000+%i*0.7071068;...
 -0.5000000+%i*0.5000000; -0.7071068+%i*0.0000000; -0.5000000-%i*0.5000000;..
  0.0000000-%i*0.7071068; 0.5000000-%i*0.5000000];
ce(1:M,1) = %T;
true_vec(1:M,1) = %T;

p_mod1 = SCI_CREATE(SCI_PSK_MOD);
sci_type = SCI_GET(p_mod1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_PSK_MOD, "sci_type != SCI_PSK_MOD");

p_dem1 = SCI_CREATE(SCI_PSK_DEM);
sci_type = SCI_GET(p_dem1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_PSK_DEM, "sci_type != SCI_PSK_DEM");
SCI_SET(p_mod1, SCI_SIZE, M);
itpp_sci_assert(SCI_GET(p_mod1, SCI_SIZE) == M, "psk_mod1.get_size() != M");

SCI_SET(p_dem1, SCI_SIZE, M);
itpp_sci_assert(SCI_GET(p_dem1, SCI_SIZE) == M, "psk_dem1.get_size() != M");

cv =  SCI_PROC(p_mod1, ce, ivx);
ivy = SCI_PROC(p_dem1, ce, cv);  

itpp_sci_assert(ivy == ivx, "ivy ! =ivx");
itpp_sci_assert((abs(cv - cv_ref) < epsilon) == true_vec, "cv ! =cv_ref");

SCI_DESTROY(p_mod1);
SCI_DESTROY(p_dem1);

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
    ulink(id);
    printf('So, this is it \n');
end
//---------------------------

