//! test itpp_sci interface
//---------------------------

path=get_absolute_file_path("sci_src_x1.sce");
chdir(path);
pwd;

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
  clear;
  clc;
  lines(0);
  dbg=0;
  exec("..\..\lib\sci_api1.sci");
  exec("..\..\lib\sci_func1.sci");  
end
//---------------------------
format('v',6);

NTAPS = 9;
WIN = WIN_HANNING;

// calculate casual sinc response for nt - normalised fractional time 
function yw = h_vec(nt)

  TN = (NTAPS - 1);       // normalised impulse response time (N-1)
  dTN = TN / 2;           // casual delay (N-1)/2
    
  // if ((nt < TN) && (nt >= 0.0)) y = sinc_pi(nt - dTN) else 0.0
  y = sinc(%pi.*(nt - dTN)) .* to_vec((nt >= 0.0) & (nt < TN));
  
  // window calculation
  select (WIN)
    case WIN_HANNING  // Hanning
      w = 0.5 * (1.0 - cos(2 * %pi * nt / TN));
    case WIN_KAISER_BESSEL // Kaiser-Besell
      w = (1 - 1.24 * cos(2 * %pi * nt / TN) + 0.244 * cos(4 * %pi * nt / TN) - 0.00305 * cos(6 * %pi * nt / TN)) / 2.48;
      scale_cor = 1 / 1.002843;
      w = w * scale_cor;
    case WIN_FLAT_TOP // Flat-Top
      w = (1 - 1.93 * cos(2 * %pi * nt / TN) + 1.29 * cos(4 * %pi * nt / TN) - 0.388 * cos(6 * %pi * nt / TN) - 0.0322 * cos(8 * %pi * nt / TN)) / 4.46;
      scale_cor = 1 / 1.0259641;
      w = w * scale_cor;
    else // 0 and others rectangular
      w = ones(nt);
      break;  
  end
  // windowing    
  yw = y .* w;
endfunction


N = NTAPS * 2;
TAU = -0.1;
epsilon = 1.0E-6;
 
p_src_x1 = SCI_CREATE(SCI_SRC_X);
sci_type = SCI_GET(p_src_x1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_SRC_X, "sci_type != SCI_SRC_X");

SCI_SET(p_src_x1, SCI_SIZE, NTAPS);
itpp_sci_assert(SCI_GET(p_src_x1, SCI_SIZE) == NTAPS, "src_x1.get_size() != NTAPS");

t = linspace(0, N - 1, N).';        // [0,1,2...] normalized sampling time 
t = t + TAU;                        // re-sample time instances
true_vec = to_bvec(ones(N,1));

cei = to_bvec(ones(N,1));
ceo = to_bvec(ones(N,1));
// combine ceio=[cei|ceo]
ceio = [cei,ceo];
// x = complex pulse 
x=zeros(N,1); 
x(1,1)=1.0;
x_x1=to_cvec(x,x);
t_x1=to_cvec(TAU*ones(N,1),zeros(N,1));
// cmat [xi+%i*xq|tau+%i*0]
xt_x1=[x_x1,t_x1];
// get impulse response
y_x1=SCI_PROC(p_src_x1, ceio, xt_x1);
// get reference - casual sinc response for noramlized re-sampling time 
h_ref = h_vec(t);
// both filters should respond with impulse response
y_x1_ref = to_cvec(h_ref, h_ref);

itpp_sci_assert((abs(y_x1 - y_x1_ref) < epsilon) == true_vec, "y_x1 != y_x1_ref");

SCI_DESTROY(p_src_x1);
 
//---------------------------
if (~ exists('ITPP_SCI_LIB'))
    ulink(id);
    printf('So, this is it \n');
end
//---------------------------

