//! test itpp_sci interface
//---------------------------

path=get_absolute_file_path("sci_casdec_x1.sce");
chdir(path);
pwd;

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
  clear;
  clc;
  lines(0);
  dbg=0;
  exec("..\..\lib\sci_api1.sci");
  exec("..\..\lib\sci_func1.sci");  
end
//---------------------------

format('v',6);
epsilon = 1.0E-6;

// cascade of 3 stages
CAS_DEC_ORDER = 8;
// mav<4>
c0=ones(4,1)*0.25+%i*zeros(4,1);
// 5x the length of impulse response
N=5*max(size(c0));
true_vec(1:N,1)=%T;
ce(1:N,1)=%T;

p_casdec_x1 = SCI_CREATE(SCI_CASDEC_X);
sci_type = SCI_GET(p_casdec_x1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_CASDEC_X, "sci_type != SCI_CASDEC_X");

p_fir_x1 = SCI_CREATE(SCI_FIR_X);
p_fir_x2 = SCI_CREATE(SCI_FIR_X);
p_fir_x3 = SCI_CREATE(SCI_FIR_X);
p_cnt1 = SCI_CREATE(SCI_COUNTER);
p_cnt2 = SCI_CREATE(SCI_COUNTER);
p_cnt3 = SCI_CREATE(SCI_COUNTER);
p_wgn_x1 = SCI_CREATE(SCI_WGN_X);

// source - random mean = (0.0+j0.0) sigma =1.0
x_x = SCI_GEN(p_wgn_x1, ce);

// discrete cascade settings
SCI_SET(p_fir_x1, SCI_TAPS, c0); 
SCI_EXEC(p_fir_x1, SCI_RESET); 
SCI_SET(p_fir_x2, SCI_TAPS, c0); 
SCI_EXEC(p_fir_x2, SCI_RESET); 
SCI_SET(p_fir_x3, SCI_TAPS, c0); 
SCI_EXEC(p_fir_x3, SCI_RESET); 
SCI_SET(p_cnt1, SCI_PARAM_N, 2); 
SCI_EXEC(p_cnt1, SCI_RESET); 
SCI_SET(p_cnt2, SCI_PARAM_N, 2); 
SCI_EXEC(p_cnt2, SCI_RESET); 
SCI_SET(p_cnt3, SCI_PARAM_N, 2); 
SCI_EXEC(p_cnt3, SCI_RESET); 

// decimator settings
SCI_SET(p_casdec_x1, SCI_ORDER, CAS_DEC_ORDER);
SCI_SET(p_casdec_x1, SCI_TAPS, c0);
SCI_EXEC(p_casdec_x1, SCI_RESET);
    
// discrete cascade proc
ya_x1 = SCI_PROC(p_fir_x1, ce, x_x); 
ce1 = SCI_GEN(p_cnt1, ce);
ya_x2 = SCI_PROC(p_fir_x2, ce1, ya_x1); 
ce2 = SCI_GEN(p_cnt2, ce1);
ya_x3 = SCI_PROC(p_fir_x3, ce2, ya_x2); 
ce3 = SCI_GEN(p_cnt3, ce2);
ya=[ya_x3, ce3+%i*zeros(N,1)];

// decimator proc 
yb = SCI_PROC(p_casdec_x1, ce, x_x);

itpp_sci_assert((abs(yb(:,1) - ya(:,1)) < epsilon) == true_vec, "yb(:,1) ! = ya(:,1)");
itpp_sci_assert(to_bvec(real(yb(:,2))) == to_bvec(real(ya(:,2))), "yb(:,2) ! = ya(:,2)");


SCI_DESTROY(p_casdec_x1);

SCI_DESTROY(p_fir_x1);
SCI_DESTROY(p_fir_x2); 
SCI_DESTROY(p_fir_x3);
SCI_DESTROY(p_cnt1); 
SCI_DESTROY(p_cnt2); 
SCI_DESTROY(p_cnt3);
SCI_DESTROY(p_wgn_x1);


format('v',10);


//---------------------------
if (~ exists('ITPP_SCI_LIB'))
    ulink(id);
    printf('So, this is it \n');
end
//---------------------------

