//! test itpp_sci interface
//---------------------------

path=get_absolute_file_path("sci_binbuff1.sce");
chdir(path);
pwd;

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
  clear;
  clc;
  lines(0);
  dbg=0;
  exec("..\..\lib\sci_api1.sci");
  exec("..\..\lib\sci_func1.sci");  
end
//---------------------------

W = 8;   // input symbols width = bytes 
N = 4;   // number of input symbols

WA = 4;   // testA output symbols width 
WB = 16;  // testB output symbols width

NA = int((N * W) / WA);       // process NA symbols of WA width
NB = int((2 * N * W) / WB);   // generate NB symbols of WB width

x1 = to_bmat([1 1 1 1 0 0 0 0; 1 1 1 1 0 0 0 1; 1 1 1 1 0 0 1 0; 1 1 1 1 0 0 1 1]);
yA_ref = to_bmat([1 1 1 1; 0 0 0 0; 1 1 1 1; 0 0 0 1; 1 1 1 1; 0 0 1 0; 1 1 1 1; 0 0 1 1]);
yB_ref = to_bmat([1 1 1 1 0 0 0 0 1 1 1 1 0 0 0 1; 1 1 1 1 0 0 1 0 1 1 1 1 0 0 1 1;...
                  1 1 1 1 0 0 0 0 1 1 1 1 0 0 0 1; 1 1 1 1 0 0 1 0 1 1 1 1 0 0 1 1]);

p_bb1 = SCI_CREATE(SCI_BINBUFF);
sci_type = SCI_GET(p_bb1, SCI_TYPE);
itpp_sci_assert(sci_type == SCI_BINBUFF, "sci_type != SCI_BINBUFF");

// buffer size in bits
SCI_SET(p_bb1, SCI_SIZE, W * N);
// symbols symbol_size
SCI_SET(p_bb1, SCI_SYMBOL_SIZE, W);

//[ceio]=[1|0]
// ceio for binbuuf
ce1(1:N,1) = %T;
ce0(1:N,1) = %F;
// push in all N bytes - ceio=[cei|cei] = [1|0] - filling -up - ceo=0
ceio = [ce1, ce0];
SCI_PROC(p_bb1, ceio, x1);
itpp_sci_assert(SCI_GET(p_bb1, SCI_N_OF_ELEM) == N*W, "nrof_elements() != N*W");

// pop in all NA symbols of WA width by processing with cei=0 - empting the buffer 
// ceio[NA,:]=[0,1]
ce1(1:NA,1) = %T;
ce0(1:NA,1) = %F;
ceio = [ce0, ce1];
SCI_SET(p_bb1, SCI_SYMBOL_SIZE, WA);
yA = SCI_PROC(p_bb1, ceio, ceio);
itpp_sci_assert(yA == yA_ref, "yA != yA_ref");
itpp_sci_assert(SCI_GET(p_bb1, SCI_N_OF_ELEM) == 0, "nrof_elements() != 0");

// put resized data - generate new symbols
ce1 = to_bvec([]); // reset size as ce1 is bigger than needed
ce1(1:NB, 1) = %T;
SCI_SET(p_bb1, SCI_VEC, rvectorize(x1));
itpp_sci_assert(SCI_GET(p_bb1, SCI_N_OF_ELEM) == N*W, "nrof_elements() != N*W");

SCI_SET(p_bb1, SCI_SYMBOL_SIZE, WB);
yB = SCI_GEN(p_bb1, ce1);
itpp_sci_assert(yB == yB_ref, "yB != yB_ref");
itpp_sci_assert(SCI_GET(p_bb1, SCI_N_OF_ELEM) == N*W, "nrof_elements() != N*W");

SCI_DESTROY(p_bb1);

//---------------------------
if (~ exists('ITPP_SCI_LIB'))
    ulink(id);
    printf('So, this is it \n');
end
//---------------------------
