global N_opt1;
global N_opt2;
global N;
global button_state1;
global button_state2;
global RMS1;
global RMS2;
global RMS3;
global RMS4;
global BER; // accumulated
global ber; // instantenous
global BERT_LOCK_FLAG;
global BERT_CLEAR_FLAG;
global C_N;
global C_N_set;
global AWGN_flag
global Figopt1;
global Figopt2;
global Figopt3;
global Figopt4;
global Figmenu1;
global Figmenu2;
global Figmenu3;
global Figmenu4;
global fftwintype;
global Nfft;
global avg;
global REF_FFT;
global REF_dB;
global RANGE_dB;
global FFT_LOG;
global PM;
global PM_set;
global PM_flag;


function Update_TCLTK()
//
global N_opt1;
global N_opt2;
global N;
global button_state1 ;
global button_state2;
global RMS1;
global RMS2;
global RMS3;
global RMS4;
global BER;
global ber;
global BERT_LOCK_FLAG;
global BERT_CLEAR_FLAG;
global C_N;
global C_N_set;
global AWGN_flag;
global Figopt1;
global Figopt2;
global Figopt3;
global Figopt4;
global Figmenu1;
global Figmenu2;
global Figmenu3;
global Figmenu4;
global fftwintype;
global Nfft;
global avg;
global REF_FFT;
global REF_dB;
global RANGE_dB;
global FFT_LOG;
global PM;
global PM_flag;

 //----------- main ----------------

 button_state2=TCL_GetVar('button_state');
  if (button_state2<>button_state1)
    button_state1=button_state2;
  end


  N_opt2 = TCL_GetVar("Nopt");
  if (N_opt2<>N_opt1)
     N_opt1 = N_opt2;
     N=floor(msscanf(N_opt1,"%d"));
  end;

// ------- C/N ----------------------

   C_N = msscanf(TCL_GetVar("C_N"),"%f");
  AWGN_flag = msscanf(TCL_GetVar("AWGN_flag"),"%d");

// ------- PM ----------------------
   PM = msscanf(TCL_GetVar("PM"),"%f");
   PM_flag = msscanf(TCL_GetVar("PM_flag"),"%d");

// ------- RMS ----------------------

  TCL_SetVar("RMS1", sprintf("%f",RMS1));
  TCL_SetVar("RMS2", sprintf("%f",RMS2));
  TCL_SetVar("RMS3", sprintf("%f",RMS3));
  TCL_SetVar("RMS4", sprintf("%f",RMS4));

// ------- MER ----------------------
  TCL_SetVar("S_rms1", sprintf("%f",RMS3));
  TCL_SetVar("E_rms1", sprintf("%f",RMS4));
  if (RMS4 > 0.0)
    MER1= 20*log10(RMS3/RMS4);
   else
    MER1=100.0;
  end
  TCL_SetVar("MER1", sprintf("%2.2f",MER1));

  TCL_SetVar("C_rms1", sprintf("%f",RMS1));
  TCL_SetVar("N_rms1", sprintf("%f",RMS2));
  if (RMS2 > 0.0)
    C_N1= 20*log10(RMS1/RMS2);
   else
    C_N1=100.0;
  end
  TCL_SetVar("C_N1", sprintf("%2.2f",C_N1));

// ------- BER ----------------------
  TCL_SetVar("e1", sprintf("%d",ber(1)));
  TCL_SetVar("cnt1", sprintf("%d",ber(2)));
  if (ber(2) > 0)
    ber1=double( ber(1))/double(ber(2));
   else
    ber1=0.0 ;
  end
  TCL_SetVar("ber1", sprintf("%1.1E",ber1));

  TCL_SetVar("E1", sprintf("%d",BER(1)));
  TCL_SetVar("CNT1", sprintf("%d",BER(2)));
  if (BER(2) > 0)
    BER1= double(BER(1))/double(BER(2));
   else
    BER1=0.0;
  end
  TCL_SetVar("BER1", sprintf("%1.1E",BER1));

  TCL_EvalStr('set h3 [winfo exists .ber1]');
  if ~(TCL_GetVar('h3')=='0') then
    if (BERT_LOCK_FLAG)
        TCL_SetVar("BERTLockFlag",1);
    else
        TCL_SetVar("BERTLockFlag",0);
    end
    TCL_EvalStr("showBERTLockFlag");
    BERT_CLEAR_FLAG = (msscanf(TCL_GetVar("BERTClearFlag"),"%d")==1);
    if ( BERT_CLEAR_FLAG ) then
        TCL_SetVar("BERTClearFlag",0);
    end
  end
  // refresh fig options
  Figopt1 = TCL_GetVar('Figopt1');
  Figopt2 = TCL_GetVar('Figopt2');
  Figopt3 = TCL_GetVar('Figopt3');
  Figopt4 = TCL_GetVar('Figopt4');
  Figmenu1 = TCL_GetVar('Figmenu1');
  Figmenu2 = TCL_GetVar('Figmenu2');
  Figmenu3 = TCL_GetVar('Figmenu3');
  Figmenu4 = TCL_GetVar('Figmenu4');
  // refresh FFT options
  fftwintypeX = TCL_GetVar('fftwintype');
  NfftX = msscanf(TCL_GetVar('Nfft'),"%d");
  // if change force reset of buffers and avg
  if ( fftwintypeX <> fftwintype)
    fftwintype = fftwintypeX;
    avg = 0;
  end;
  // if change force reset of buffers and avg
  if ( NfftX <> Nfft)
     Nfft = NfftX;
     avg = 0;
  end;

  REF_FFT = msscanf(TCL_GetVar("REF_FFT"),"%f");
  REF_dB= msscanf(TCL_GetVar("REF_dB"),"%f");
  RANGE_dB = msscanf(TCL_GetVar("RANGE_dB"),"%f");
  FFT_LOG = msscanf(TCL_GetVar("FFT_LOG"),"%d");

endfunction

function csim_tcl_win_destroy()
// Destroy the toplevel widgets
  TCL_EvalStr("catch { destroy .app1 }");
  TCL_EvalStr("catch { destroy .cn1 }");
  TCL_EvalStr("catch { destroy .ber1 }");
  TCL_EvalStr("catch { destroy .mer1 }");
  TCL_EvalStr("catch { destroy .rms1 }");
  TCL_EvalStr("catch { destroy .fig1 }");
  TCL_EvalStr("catch { destroy .fft1 }");
  TCL_EvalStr("catch { destroy .pm1 }");
endfunction


// Try to do invoke Main TCL script in the novel way:
// set variables first
// TCL_SetVar("button_state", "state_STOP");
TCL_SetVar("RMS1", 0.0);
TCL_SetVar("RMS2", 0.0);
TCL_SetVar("RMS3", 0.0);
TCL_SetVar("RMS4", 0.0);
TCL_SetVar("C_rms", 0.0);
TCL_SetVar("N_rms", 0.0);

TCL_SetVar("C_N1", 100.0);
TCL_SetVar("S_rms", 0.0);
TCL_SetVar("E_rms", 0.0);
TCL_SetVar("MER1", 100.0);

TCL_SetVar("AWGN_flag", AWGN_flag);
TCL_SetVar("C_Nmin", C_N_set(1));
TCL_SetVar("C_Nmax", C_N_set(2));
TCL_SetVar("C_N0", C_N_set(3));
TCL_SetVar("C_N0", C_N_set(3));

TCL_SetVar("PMmin", PM_set(1));
TCL_SetVar("PMmax", PM_set(2));
TCL_SetVar("PM0", PM_set(3));
TCL_SetVar("PM", PM_set(3));
TCL_SetVar("PM_flag", PM_flag);


TCL_SetVar("e1", 0.0);
TCL_SetVar("cnt1", 0.0);
TCL_SetVar("ber1", 0.0);
TCL_SetVar("E1", 0.0);
TCL_SetVar("CNT1", 0.0);
TCL_SetVar("BER1", 0.0);
TCL_SetVar("BERTLockFlag", 0);
TCL_SetVar("BERTClearFlag", 0);
// graphics - set menu options
TCL_SetVar("Fig1menu1", "Cint_del/Sint");
TCL_SetVar("Fig1menu2", "fft(Ciq)");
TCL_SetVar("Fig1menu3", "fft(C)");
TCL_SetVar("Fig1menu4", "fft(S)");
TCL_SetVar("Fig2menu1", "Ciq");
TCL_SetVar("Fig2menu2", "sig1(Ciq)");
TCL_SetVar("Fig2menu3", "sig2(C)");
TCL_SetVar("Fig2menu4", "sig3(S)");
TCL_SetVar("Fig3menu1", "bert state");
TCL_SetVar("Fig3menu2", "wsig1(w*Ciq)");
TCL_SetVar("Fig3menu3", "wsig2(w*C)");
TCL_SetVar("Fig3menu4", "wsig3(w*S)");
TCL_SetVar("Fig4menu1", "IQ");
TCL_SetVar("Fig4menu2", "C");
TCL_SetVar("Fig4menu3", "Niq");
TCL_SetVar("Fig4menu4", "");
// init variables by read back
TCL_SetVar("Figopt1", "opt1");
TCL_SetVar("Figmenu1",  TCL_GetVar('Fig1menu1'));
TCL_SetVar("Figopt2", "opt1");
TCL_SetVar("Figmenu2", TCL_GetVar('Fig2menu1'));
TCL_SetVar("Figopt3", "opt1");
TCL_SetVar("Figmenu3", TCL_GetVar('Fig3menu1'));
TCL_SetVar("Figopt4", "opt1");
TCL_SetVar("Figmenu4", TCL_GetVar('Fig4menu1'));
// fft
TCL_SetVar("fftwintype", 'kais');
TCL_SetVar("Nfft", sprintf("%d",N_FFT)); // force decimal not float
// set variables to ensure avg=0 when change
fftwintype = TCL_GetVar('fftwintype');
Nfft = msscanf(TCL_GetVar('Nfft'),"%d");
// plot FFT options
TCL_SetVar("REF_FFT", 10.0);
TCL_SetVar("REF_dB", +20.0);
TCL_SetVar("RANGE_dB", 120.0);
TCL_SetVar("FFT_LOG", sprintf("%d",1)); // force decimal not float

//-----------------------------------------------
// and then run script
TCL_EvalFile("..\tcl\tk_app02_v1.tcl");

