// ------------------------------------------
// load config struct in text
function [confstruct,err]=loadconfig(conffilename)
  
  confstruct=struct();
  [fd,err]=mopen(conffilename , "r");
  if ( err ==0 )
    [n,confstruct.NFFT] = mfscanf(fd,"NFFT=%d\n");
    [n,confstruct.CP] = mfscanf(fd,"CP=%d\n");
    [n,confstruct.M] = mfscanf(fd,"M=%d\n");
    [n,confstruct.TX_SCALE] = mfscanf(fd,"TX_SCALE=%f\n");
    [n,confstruct.PA] = mfscanf(fd,"PA=%f\n");    
    [n,confstruct.DATA_BYTES] = mfscanf(fd,"DATA_BYTES=%s\n");    
    [n,confstruct.PILOT_BITS] = mfscanf(fd,"PILOT_BITS=%s\n");
    [n,confstruct.PILOT_INDX] = mfscanf(fd,"PILOT_INDX=%s\n");
    [n,confstruct.ZERO_INDX] = mfscanf(fd,"ZERO_INDX=%s\n");    
    [n,confstruct.DATA_PRBS] = mfscanf(fd,"DATA_PRBS=%d\n");
    [n,confstruct.PILOT_PRBS] = mfscanf(fd,"PILOT_PRBS=%d\n");
    [n,confstruct.N_SYMB] = mfscanf(fd,"N_SYMB=%d\n");
    [n,confstruct.RMS_MAV] = mfscanf(fd,"RMS_MAV=%d\n");    
    mfscanf(fd,"C_NdB=");
    // C_Nmin C_Nmax C_N0 - initial value in dB
    [n,confstruct.C_N_set] = mfscanf(3,fd,"%f");
    mfscanf(fd,"\n");
  end;
  mclose(fd);
endfunction

