global N_SYMB;
global N_opt1;
global N_opt2;
global N_symb;
global button_state1;
global button_state2;
// ------- FIG ----------------------
global Figopt1;
global Figopt2;
global Figopt3;
global Figopt4;
global Figmenu1;
global Figmenu2;
global Figmenu3;
global Figmenu4;
// ------- RMS ----------------------
global RMS1;
global RMS2;
global RMS3;
global RMS4;
// ------- C/N ----------------------
global C_N;
global C_N_set;
global AWGN_flag;
// ------- BER ----------------------
global BER; // accumulated
global ber; // instantaneous
global BERT_LOCK_FLAG;
global BERT_CLEAR_FLAG;


function Update_TCLTK()
//
global N_opt1;
global N_opt2;
global N_symb;
global button_state1 ;
global button_state2;
// ------- FIG ----------------------
global Figopt1;
global Figopt2;
global Figopt3;
global Figopt4;
global Figmenu1;
global Figmenu2;
global Figmenu3;
global Figmenu4;
// ------- RMS ----------------------
global RMS1;
global RMS2;
global RMS3;
global RMS4;
// ------- C/N ----------------------
global C_N;
global C_N_set;
global AWGN_flag;
// ------- BER ----------------------
global BER; // accumulated
global ber; // instantaneous
global BERT_LOCK_FLAG;
global BERT_CLEAR_FLAG;

//----------- main ----------------

 button_state2=TCL_GetVar('button_state');
  if (button_state2<>button_state1)
    button_state1=button_state2;
  end


  N_opt2 = TCL_GetVar("Nopt");
  if (N_opt2<>N_opt1)
     N_opt1 = N_opt2;
     N_symb=floor(msscanf(N_opt1,"%d"));
  end;

// ------- FIG ----------------------
  Figopt1 = TCL_GetVar('Figopt1');
  Figopt2 = TCL_GetVar('Figopt2');
  Figopt3 = TCL_GetVar('Figopt3');
  Figopt4 = TCL_GetVar('Figopt4');
  Figmenu1 = TCL_GetVar('Figmenu1');
  Figmenu2 = TCL_GetVar('Figmenu2');
  Figmenu3 = TCL_GetVar('Figmenu3');
  Figmenu4 = TCL_GetVar('Figmenu4');

// ------- RMS ----------------------

  TCL_SetVar("RMS1", sprintf("%f",RMS1));
  TCL_SetVar("RMS2", sprintf("%f",RMS2));
  TCL_SetVar("RMS3", sprintf("%f",RMS3));
  TCL_SetVar("RMS4", sprintf("%f",RMS4));

// ------- C/N ----------------------
  C_N = msscanf(TCL_GetVar("C_N"),"%f");
  AWGN_flag = msscanf(TCL_GetVar("AWGN_flag"),"%d");
// ------- MER ----------------------
  TCL_SetVar("S_rms1", sprintf("%f",RMS3));
  TCL_SetVar("E_rms1", sprintf("%f",RMS4));
  if (RMS4 > 0.0)
    MER1= 20*log10(RMS3/RMS4);
   else
    MER1=100.0;
  end
  TCL_SetVar("MER1", sprintf("%2.2f",MER1));

  TCL_SetVar("C_rms1", sprintf("%f",RMS1));
  TCL_SetVar("N_rms1", sprintf("%f",RMS2));
  if (RMS2 > 0.0)
    C_N1= 20*log10(RMS1/RMS2);
   else
    C_N1=100.0;
  end
  TCL_SetVar("C_N1", sprintf("%2.2f",C_N1));
// ------- BER ----------------------
  TCL_SetVar("e1", sprintf("%d",ber(1)));
  TCL_SetVar("cnt1", sprintf("%d",ber(2)));
  if (ber(2) > 0)
    ber1=double( ber(1))/double(ber(2));
   else
    ber1=0.0 ;
  end
  TCL_SetVar("ber1", sprintf("%1.1E",ber1));

  TCL_SetVar("E1", sprintf("%d",BER(1)));
  TCL_SetVar("CNT1", sprintf("%d",BER(2)));
  if (BER(2) > 0)
    BER1= double(BER(1))/double(BER(2));
   else
    BER1=0.0;
  end
  TCL_SetVar("BER1", sprintf("%1.1E",BER1));

  TCL_EvalStr('set h3 [winfo exists .ber1]');
  if ~(TCL_GetVar('h3')=='0') then
    if (BERT_LOCK_FLAG)
        TCL_SetVar("BERTLockFlag",1);
    else
        TCL_SetVar("BERTLockFlag",0);
    end
    TCL_EvalStr("showBERTLockFlag");
    BERT_CLEAR_FLAG = (msscanf(TCL_GetVar("BERTClearFlag"),"%d")==1);
    if ( BERT_CLEAR_FLAG ) then
        TCL_SetVar("BERTClearFlag",0);
    end
  end

endfunction

function csim_tcl_win_destroy()
// Destroy the toplevel widgets
  TCL_EvalStr("catch { destroy .app3 }");
// ------- FIG ----------------------
  TCL_EvalStr("catch { destroy .fig1 }");
// ------- RMS ----------------------
  TCL_EvalStr("catch { destroy .rms1 }");
// ------- C/N ----------------------
  TCL_EvalStr("catch { destroy .cn1 }");
// ------- MER ----------------------
  TCL_EvalStr("catch { destroy .mer1 }");
// ------- MER ----------------------
  TCL_EvalStr("catch { destroy .ber1 }");
endfunction


// Try to do invoke Main TCL script in the novel way:
// set variables first
// TCL_SetVar("button_state", "state_STOP");
// graphics - set menu options
// init variables by read back
TCL_SetVar("Nopt", N_SYMB);

// ------- FIG ----------------------
// graphics - set menu options
TCL_SetVar("Fig1menu1", "Ctx");
TCL_SetVar("Fig1menu2", "");
TCL_SetVar("Fig1menu3", "");
TCL_SetVar("Fig1menu4", "");

TCL_SetVar("Fig2menu1", "Crx");
TCL_SetVar("Fig2menu2", "");
TCL_SetVar("Fig2menu3", "");
TCL_SetVar("Fig2menu4", "");

TCL_SetVar("Fig3menu1", "d_carr");
TCL_SetVar("Fig3menu2", "d_err");
TCL_SetVar("Fig3menu3", "d_sliced");
TCL_SetVar("Fig3menu4", "carriers");

TCL_SetVar("Fig4menu1", "p_carr");
TCL_SetVar("Fig4menu2", "p_err");
TCL_SetVar("Fig4menu3", "p_sliced");
TCL_SetVar("Fig4menu4", "");

// init variables by read back
TCL_SetVar("Figopt1", "opt1");
TCL_SetVar("Figmenu1",  TCL_GetVar('Fig1menu1'));
TCL_SetVar("Figopt2", "opt1");
TCL_SetVar("Figmenu2", TCL_GetVar('Fig2menu1'));
TCL_SetVar("Figopt3", "opt1");
TCL_SetVar("Figmenu3", TCL_GetVar('Fig3menu1'));
TCL_SetVar("Figopt4", "opt1");
TCL_SetVar("Figmenu4", TCL_GetVar('Fig4menu1'));

// ------- RMS ----------------------
TCL_SetVar("RMS1", 0.0);
TCL_SetVar("RMS2", 0.0);
TCL_SetVar("RMS3", 0.0);
TCL_SetVar("RMS4", 0.0);
// ------- C/N ----------------------
TCL_SetVar("AWGN_flag", AWGN_flag);
TCL_SetVar("C_Nmin", C_N_set(1));
TCL_SetVar("C_Nmax", C_N_set(2));
TCL_SetVar("C_N0", C_N_set(3));
TCL_SetVar("C_N", C_N_set(3));
// ------- BER ----------------------
TCL_SetVar("e1", 0.0);
TCL_SetVar("cnt1", 0.0);
TCL_SetVar("ber1", 0.0);
TCL_SetVar("E1", 0.0);
TCL_SetVar("CNT1", 0.0);
TCL_SetVar("BER1", 0.0);
TCL_SetVar("BERTLockFlag", 0);
TCL_SetVar("BERTClearFlag", 0);


//-----------------------------------------------
// and then run script
TCL_EvalFile("..\tcl\tk_app03_v1.tcl");

