clear;
clearglobal;
clc;
lines(0);
path=get_absolute_file_path("Test_resmap.sce")
chdir(path);
pwd


// return only qualified samples 
function [y]=ReSamp(ce,a)
 y=[];
 j=1;
 I=max(size(ce));
 for i=1:I
    if (ce(i))
       y=[y', a(i,:)]'; // make it a column vector - one row is a row vector
    end           
 end   
endfunction    

// return disance and lenght of two [0,1] vectors
function [e,n]=HammingDist(a,b)
    // xor     
    x=pmodulo(a+b,2);
    e=sum(x);
    n=max(size(x));
endfunction;

bRx = [...
  %T, %T;
  %F, %T;
  %T, %T;
  %T, %T] 

aRx = [...
  %T;
  %F;
  %T;
  %T] 
  
ce = [...
 %T;
 %T;
 %T;
 %T]

ya=ReSamp(ce,aRx)
yb=ReSamp(ce,bRx)
