function DispApp() 
global h_fig1 h_fig2 h_fig3 h_fig4;

global N_opt1 N_opt2 N;
global Figopt1 Figopt2 Figopt3 Figopt4;
global Figmenu1 Figmenu2 Figmenu3 Figmenu4;
global REF_FFT REF_dB RANGE_dB FFT_LOG;

global s_sp1 s_sp2 s_sp3 s_sp4;
global N_BAUDS N_TRACES N_EYE;
global eyeYRx eyeYTx eyeSRx eyeSTx;
global eyeT eyeStyleY eyeStyleS;

global fD phID fModDel phMod phd;             
global sTxDel sRx iTxDel iRx; 
global ceTxD ceTx ceRx;
global cTx;

global winfft;

    // proc data
    s_sp1 = calc_spec(s_sp1,winfft);
    s_sp2 = calc_spec(s_sp2,winfft);
    s_sp3 = calc_spec(s_sp3,winfft);
    s_sp4 = calc_spec(s_sp4,winfft);
    
    // ---   fig1
    scf(h_fig1);
    clf(h_fig1); // xbasc();
    drawlater();
    select Figopt1        
      case "opt1"
        if (FFT_LOG == 1)
          plot2d(s_sp3.ff,20*log10(s_sp3.spect),     rect=[s_sp3.minff, REF_dB-RANGE_dB, s_sp3.maxff, REF_dB], style=5);
          plot2d(s_sp3.ff,20*log10(s_sp3.avg_spect), rect=[s_sp3.minff, REF_dB-RANGE_dB, s_sp3.maxff, REF_dB], style=2);
        else
          plot2d(s_sp3.ff,s_sp3.spect,     rect=[s_sp3.minff,0,s_sp3.maxff, REF_FFT], style=5);
          plot2d(s_sp3.ff,s_sp3.avg_spect, rect=[s_sp3.minff,0,s_sp3.maxff, REF_FFT], style=2);
        end
        xgrid();

      case "opt2"
        if (FFT_LOG == 1)
          plot2d(s_sp2.ff,20*log10(s_sp2.spect),     rect=[s_sp2.minff, REF_dB-RANGE_dB, s_sp2.maxff, REF_dB], style=5);
          plot2d(s_sp2.ff,20*log10(s_sp2.avg_spect), rect=[s_sp2.minff, REF_dB-RANGE_dB, s_sp2.maxff, REF_dB], style=2);
        else
          plot2d(s_sp2.ff,s_sp2.spect,     rect=[s_sp2.minff,0,s_sp2.maxff, REF_FFT], style=5);
          plot2d(s_sp2.ff,s_sp2.avg_spect, rect=[s_sp2.minff,0,s_sp2.maxff, REF_FFT], style=2);
        end
        xgrid();    

      case "opt3"
        if (FFT_LOG == 1)
          plot2d(s_sp1.ff,20*log10(s_sp1.spect),     rect=[s_sp1.minff, REF_dB-RANGE_dB, s_sp1.maxff, REF_dB], style=5);
          plot2d(s_sp1.ff,20*log10(s_sp1.avg_spect), rect=[s_sp1.minff, REF_dB-RANGE_dB, s_sp1.maxff, REF_dB], style=2);
        else
          plot2d(s_sp1.ff,s_sp1.spect,     rect=[s_sp1.minff,0,s_sp1.maxff, REF_FFT], style=5);
          plot2d(s_sp1.ff,s_sp1.avg_spect, rect=[s_sp1.minff,0,s_sp1.maxff, REF_FFT], style=2);
        end
        xgrid();

      case "opt4"
        if (FFT_LOG == 1)
          plot2d(s_sp4.ff,20*log10(s_sp4.spect),     rect=[s_sp4.minff, REF_dB-RANGE_dB, s_sp4.maxff, REF_dB], style=5);
          plot2d(s_sp4.ff,20*log10(s_sp4.avg_spect), rect=[s_sp4.minff, REF_dB-RANGE_dB, s_sp4.maxff, REF_dB], style=2);
        else
          plot2d(s_sp4.ff,s_sp4.spect,     rect=[s_sp4.minff,0,s_sp4.maxff, REF_FFT], style=5);
          plot2d(s_sp4.ff,s_sp4.avg_spect, rect=[s_sp4.minff,0,s_sp4.maxff, REF_FFT], style=2);
        end
        xgrid();
    end
    drawnow();
    

    // ---   fig2
    scf(h_fig2);
    clf(h_fig2); // xbasc();
    drawlater();
    select Figopt2        
      case "opt1"
        subplot(2,1,1);  xtitle("fD*RxDev");
        plot2d3(0:N-1, fD*RxDev, rect=[0,-1.5,N,+1.5], style=5); // blue
        plot2d3(0:N-1, 0.1*to_vec(ceTxD), rect=[0,-1.5,N,+1.5]);
        plot2d3(0:N-1, 0.3*to_vec(ceRx), rect=[0,-1.5,N,+1.5]);
        subplot(2,1,2);  xtitle("sRx");
        plot2d3(0:N-1, sRx, rect=[0,-1.5,N,+1.5], style=5); // red;  // blue
        plot2d3(0:N-1, 0.1*to_vec(ceTxD), rect=[0,-1.5,N,+1.5]);
        plot2d3(0:N-1, 0.3*to_vec(ceRx), rect=[0,-1.5,N,+1.5]);
            
      case "opt2"
        if (MOD == "MSK")
          subplot(2,1,1);  xtitle("phID*2");
          plot2d3(0:N-1, phID, rect=[0,-1.5,N,+1.5], style=5); // red
        else
          subplot(2,1,1);  xtitle("phID*RxDev/UP");
          plot2d3(0:N-1, phID*RxDev/UP, rect=[0,-1.5,N,+1.5], style=5); // red
        end            
          subplot(2,1,2);  xtitle("phd");
          plot2d3(0:N-1,  phd, rect=[0,-1.5,N,1.5], style=2);  // blue

      case "opt3"
        clf(h_fig2); // xbasc();
        xtitle("Rx Eye");
        plot2d(eyeT,eyeYRx,eyeStyleY, rect=[0,-1.5,N_BAUDS*UP+1,+1.5]);
        plot2d3(eyeT,eyeSRx,eyeStyleS, rect=[0,-1.5,N_BAUDS*UP+1,+1.5]);

      case "opt4" 
        subplot(2,1,1);  xtitle("phMod");
        plot2d3(0:N-1, phMod, rect=[0,-1.5,N,+1.5], style=5); // red
        subplot(2,1,2);  xtitle("phd");
        plot2d3(0:N-1,  phd, rect=[0,-1.5,N,1.5], style=2);  // blue
    end
    drawnow();
    
    // ---   fig3
    scf(h_fig3);
    clf(h_fig3); // xbasc();
    drawlater();
    select Figopt3        
      case "opt1" 
        clf(h_fig3); // xbasc();
        xtitle("Rx Eye");
        plot2d(eyeT,eyeYRx,eyeStyleY, rect=[0,-1.5,N_BAUDS*UP+1,+1.5]);
        plot2d3(eyeT,eyeSRx,eyeStyleS, rect=[0,-1.5,N_BAUDS*UP+1,+1.5]);
      case "opt2"
        if (FFT_LOG == 1)
          plot2d(s_sp2.ff,20*log10(s_sp2.spect),     rect=[s_sp2.minff, REF_dB-RANGE_dB, s_sp2.maxff, REF_dB], style=5);
          plot2d(s_sp2.ff,20*log10(s_sp2.avg_spect), rect=[s_sp2.minff, REF_dB-RANGE_dB, s_sp2.maxff, REF_dB], style=2);
        else
          plot2d(s_sp2.ff,s_sp2.spect,     rect=[s_sp2.minff,0,s_sp2.maxff, REF_FFT], style=5);
          plot2d(s_sp2.ff,s_sp2.avg_spect, rect=[s_sp2.minff,0,s_sp2.maxff, REF_FFT], style=2);
        end
        xgrid();    
      case "opt3"
        if (FFT_LOG == 1)
          plot2d(s_sp1.ff,20*log10(s_sp1.spect),     rect=[s_sp1.minff, REF_dB-RANGE_dB, s_sp1.maxff, REF_dB], style=5);
          plot2d(s_sp1.ff,20*log10(s_sp1.avg_spect), rect=[s_sp1.minff, REF_dB-RANGE_dB, s_sp1.maxff, REF_dB], style=2);
        else
          plot2d(s_sp1.ff,s_sp1.spect,     rect=[s_sp1.minff,0,s_sp1.maxff, REF_FFT], style=5);
          plot2d(s_sp1.ff,s_sp1.avg_spect, rect=[s_sp1.minff,0,s_sp1.maxff, REF_FFT], style=2);
        end
        xgrid();
      case "opt4"
        subplot(2,1,1); xtitle("real(cTx)");  
        plot2d3(0:N-1, real(cTx), rect=[0,-1.5,N,+1.5], style=2); // blue
        subplot(2,1,2); xtitle("imag(cTx)");
        plot2d3(0:N-1, imag(cTx), rect=[0,-1.5,N,+1.5], style=2);  // red         
    end
    drawnow();

    // ---   fig4
    scf(h_fig4);
    clf(h_fig4); // xbasc();
    drawlater();
    select Figopt4        
      case "opt1" 
        subplot(2,1,1);xtitle("sTxDel");            
        plot2d3(0:N-1, sTxDel, rect=[0,-1.5,N,+1.5], style=2 );
        plot2d3(0:N-1, 0.1*to_vec(ceTxD), rect=[0,-1.5,N,+1.5]);
        subplot(2,1,2); xtitle("sTxDel+sRx");             
        plot2d3(0:N-1, sTxDel, rect=[0,-1.5,N,+1.5], style=2);
        plot2d3(0:N-1, sRx, rect=[0,-1.5,N,+1.5], style=5); // blue
        plot2d3(0:N-1, 0.1*to_vec(ceTxD), rect=[0,-1.5,N,+1.5]);            
      case "opt2"
        subplot(2,1,1); xtitle("sRx"); 
        plot2d3(0:N-1, sRx, rect=[0,-1.5,N,+1.5], style=5); // red
        plot2d3(0:N-1, 0.1*to_vec(ceTxD), rect=[0,-1.5,N,+1.5]);
        plot2d3(0:N-1, 0.3*to_vec(ceRx), rect=[0,-1.5,N,+1.5]);
        subplot(2,1,2); xtitle("phID");
        plot2d3(0:N-1, phID, rect=[0,-0.5,N,+0.5], style =5);
        plot2d3(0:N-1, 0.1*to_vec(ceTxD), rect=[0,-1.5,N,+1.5]);
      case "opt3"
        subplot(2,1,1); xtitle("sRx + phInt"); 
        plot2d3(0:N-1, sRx, rect=[0,-1.5,N,+1.5], style=5); // red
        plot2d3(0:N-1, phInt, rect=[0,-1.5,N,+1.5], style=3);
        plot2d3(0:N-1, 0.1*to_vec(ceTxD), rect=[0,-1.5,N,+1.5]);
        plot2d3(0:N-1, 0.3*to_vec(ceRx), rect=[0,-1.5,N,+1.5]);
        subplot(2,1,2); xtitle("iRx+iTxDel");
        plot2d3(0:N-1, double(iRx), rect=[0,0,N, M], style=5);  // red 
        plot2d3(0:N-1, double(iTxDel), rect=[0,0,N, M], style=2);  // red
        plot2d3(0:N-1, 0.3*to_vec(ceRx), rect=[0,0,N, M]);              
      case "opt4"
        clf(h_fig4); // xbasc();
        xtitle("Tx Eye");
        plot2d(eyeT,eyeYTx,eyeStyleY, rect=[0,-1.5,N_BAUDS*UP+1,+1.5]);
        plot2d3(eyeT,eyeSTx,eyeStyleS, rect=[0,-1.5,N_BAUDS*UP+1,+1.5]);
    end
    drawnow();
    
endfunction
