
// constellation SIZE of PAM modulator
MOD = simConf.MOD;
M = simConf.M;
UP = simConf.UP;
FIR_TX = simConf.FIR_TX;
FIR_RX = simConf.FIR_RX;
TxDev = simConf.TxDev;
RxDev = simConf.RxDev;
// size of PRBS generator
PRBS = simConf.PRBS;
// C_NdB for wgn_x
C_N_set = simConf.C_N_set
// MAV for RMS estimator
RMS_MAV = simConf.RMS_MAV;
// size of FFT for spectral analysis
N_FFT = simConf.N_FFT;
// size of graphic circulat buff for eye
N_GCB = simConf.N_GCB;
// use BERT or XOR
BERT = simConf.BERT;

// FIR TX shaper interpolator handler
fir_tx = read(FIR_TX,-1,1);
Nh_tx = max(size(fir_tx))
h_tx=fir_tx;
TxG = 1.0/max(fir_tx)
// FIR RX SRRC handler
fir_rx = read(FIR_RX,-1,1);
Nh_rx = max(size(fir_rx))
h_rx = fir_rx + %i*(zeros(fir_rx));

// word lenght    
W = ceil(log2(M));

// prbs source
p_prbs1 = SCI_CREATE(SCI_LFSR);
SCI_SET(p_prbs1, SCI_PRBS, PRBS);
SCI_SET(p_prbs1, SCI_SYMBOL_SIZE, W);
// bin to int 
p_b2i1=SCI_CREATE(SCI_BIN2INT);
SCI_SET(p_b2i1, SCI_SYMBOL_SIZE, W);
// int to bin 
p_i2b1 = SCI_CREATE(SCI_INT2BIN);
SCI_SET(p_i2b1, SCI_SYMBOL_SIZE, W);
p_i2b2 = SCI_CREATE(SCI_INT2BIN);
SCI_SET(p_i2b2, SCI_SYMBOL_SIZE, W);
// PAM mod 
p_mod1 = SCI_CREATE(SCI_PAM_MOD);
SCI_SET(p_mod1, SCI_SIZE, M);
// PAM demod 
p_dem1 = SCI_CREATE(SCI_PAM_DEM);
SCI_SET(p_dem1, SCI_SIZE, M);
// UP counter
p_cnt1 = SCI_CREATE(SCI_COUNTER);
SCI_SET(p_cnt1, SCI_PARAM_N, UP);
SCI_SET(p_cnt1,SCI_STATE, UP-1);

// RX_filter
p_fir_rx1 = SCI_CREATE(SCI_FIR_X);
SCI_SET(p_fir_rx1, SCI_TAPS, h_rx);
// RX_filter copy to determine NBW
p_fir_rx2 = SCI_CREATE(SCI_FIR_X);
SCI_SET(p_fir_rx2, SCI_TAPS, h_rx);

// TX_filter
p_fir_tx1 = SCI_CREATE(SCI_FIR_UP);
SCI_SET(p_fir_tx1, SCI_TAPS, h_tx);
// delays
// Z^(-K) filters - for xFSK - there is a shaping 
// and d1-delay is for symbol symbol begining
// and not for sampling instant!
if (MOD == "xFSK")
  d1 = ceil((Nh_tx-1)/2) + ceil((Nh_rx-1)/2)-floor(UP/2)
else
  d1 = ceil((Nh_rx-1)/2)
end    
h_del = zeros(1:d1+1);
h_del(d1+1) = 1.0;
p_firdel1 = SCI_CREATE(SCI_FIR);
SCI_SET(p_firdel1, SCI_TAPS, h_del);

d2 = floor(UP/2)
h_del = zeros(1:d2+1);
h_del(d2+1) = 1.0;
p_firdel2 = SCI_CREATE(SCI_FIR);
SCI_SET(p_firdel2, SCI_TAPS, h_del);

if (MOD == "xFSK")
  d3=d1+d2
else
  d3=d1+UP
end    
h_del=zeros(1:d3+1);
h_del(d3+1)=1.0;
p_firdel3 = SCI_CREATE(SCI_FIR);
SCI_SET(p_firdel3, SCI_TAPS, h_del);

if (MOD == "xFSK")
  d4 = d1+d2
else
  d4 = d1+d2+UP
end    
h_del = zeros(1:d4+1);
h_del(d4+1) = 1.0;
p_firdel4 = SCI_CREATE(SCI_FIR);
SCI_SET(p_firdel4, SCI_TAPS, h_del);
// z^(-1)
h_del = zeros(1:2);
h_del(2) = 1.0;
p_firdel5 = SCI_CREATE(SCI_FIR);
SCI_SET(p_firdel5, SCI_TAPS, h_del);

d6=(Nh_rx-1)/2
h_del = zeros(1:d6+1);
h_del(d6+1) = 1.0;
p_firdel6 = SCI_CREATE(SCI_FIR);
SCI_SET(p_firdel6, SCI_TAPS, h_del);


// frequency deviation multipliers
p_amp1 = SCI_CREATE(SCI_AMP);
SCI_SET(p_amp1, SCI_GAIN, TxDev);
p_amp2 = SCI_CREATE(SCI_AMP);
SCI_SET(p_amp2, SCI_GAIN, RxDev);
p_amp3 = SCI_CREATE(SCI_AMP);
SCI_SET(p_amp3, SCI_GAIN, RxDev/UP);
p_amp4 = SCI_CREATE(SCI_AMP);
SCI_SET(p_amp4, SCI_GAIN, 2.0);

// phase for sine PM
p_nco1 = SCI_CREATE(SCI_NCO);
// sine PM
p_ejp1 = SCI_CREATE(SCI_EJP);
// cordic
p_iq2ap1 = SCI_CREATE(SCI_IQ2AP);

// WGN_X - complex noise generator
p_wgn_x1 = SCI_CREATE(SCI_WGN_X);

// RMS to measure modulated carrier
p_rms_x1 = SCI_CREATE(SCI_RMS_X);
SCI_SET(p_rms_x1,SCI_SIZE, RMS_MAV);
// RMS to measure noise
p_rms_x2 = SCI_CREATE(SCI_RMS_X);
SCI_SET(p_rms_x2,SCI_SIZE, RMS_MAV);
// RMS to measure noise
p_rms_x3 = SCI_CREATE(SCI_RMS_X);
SCI_SET(p_rms_x3,SCI_SIZE, RMS_MAV);

// RMS to measure noise
p_rms4 = SCI_CREATE(SCI_RMS);
SCI_SET(p_rms4, SCI_SIZE, RMS_MAV);

// RMS to measure noise
p_rms5 = SCI_CREATE(SCI_RMS);
SCI_SET(p_rms5, SCI_SIZE, RMS_MAV);

// bert
p_bert1 = SCI_CREATE(SCI_BERT);
SCI_SET(p_bert1, SCI_PRBS, PRBS);
// bert correlator lenght 40 bits
BERT_LEN = 40;
SCI_SET(p_bert1, SCI_LENGTH, BERT_LEN);
// symbol lenght must be set after BERT_LEN
SCI_SET(p_bert1, SCI_SYMBOL_SIZE, W);
// ERR < T0 - for lock into BERT_FSM_SYNC state
// ERR < T1 - for staying locked in BERT_FSM_SYNC
// ERR < T2 - for staying in BERT_FSM_nSYNC - not error counting - but tracking
// T= [T0, T1, T2] - T0/LENGHT = BER < 4/40 (less than 1.0E-1); 
BERT_TH = [4 8 10]; 
SCI_SET(p_bert1, SCI_THRESHOLD, BERT_TH);
// set inital state
// SCI_SET(p_bert1, SCI_sTxM, BERT_RELOAD);
SCI_EXEC(p_bert1, SCI_START);

// FFT CIRCBUFF_X  
p_fft_x1 = SCI_CREATE(SCI_CIRCBUFF_X);
SCI_SET(p_fft_x1, SCI_SIZE, N_FFT);
p_fft_x2 = SCI_CREATE(SCI_CIRCBUFF_X);
SCI_SET(p_fft_x2, SCI_SIZE, N_FFT);
p_fft_x3 = SCI_CREATE(SCI_CIRCBUFF_X);
SCI_SET(p_fft_x3, SCI_SIZE, N_FFT);
p_fft_x4 = SCI_CREATE(SCI_CIRCBUFF_X);
SCI_SET(p_fft_x4, SCI_SIZE, N_FFT);

// Create structs to keep FFT data 
s_sp1 = struct('p_fft_x',p_fft_x1, 'Nfft', N_FFT, 'Navg', 0, 'sig', zeros(1:N_FFT),...
'wsig', zeros(1:N_FFT), 'spect', %eps*ones(1:N_FFT), 'avg_spect', %eps*ones(1:N_FFT),...
'ff',zeros(1:N_FFT),'minff', -0.5, 'maxff', +0.5);
s_sp2 = struct('p_fft_x',p_fft_x2, 'Nfft', N_FFT, 'Navg', 0, 'sig', zeros(1:N_FFT),...
'wsig', zeros(1:N_FFT), 'spect', %eps*ones(1:N_FFT), 'avg_spect', %eps*ones(1:N_FFT),...
'ff',zeros(1:N_FFT), 'minff', -0.5, 'maxff', +0.5 );
s_sp3 = struct('p_fft_x',p_fft_x3, 'Nfft', N_FFT, 'Navg', 0, 'sig', zeros(1:N_FFT),...
'wsig', zeros(1:N_FFT), 'spect', %eps*ones(1:N_FFT), 'avg_spect', %eps*ones(1:N_FFT),...
'ff',zeros(1:N_FFT), 'minff', -0.5, 'maxff', +0.5);
s_sp4 = struct('p_fft_x',p_fft_x4, 'Nfft', N_FFT, 'Navg', 0, 'sig', zeros(1:N_FFT),...
'wsig', zeros(1:N_FFT), 'spect', %eps*ones(1:N_FFT), 'avg_spect', %eps*ones(1:N_FFT),...
'ff',zeros(1:N_FFT), 'minff', -0.5, 'maxff', +0.5);

// Bauds in eye
N_BAUDS=3;
// Traces in eye diagram
N_TRACES=floor(N_GCB/(N_BAUDS*UP));
N_EYE = N_BAUDS*UP*N_TRACES

// Eye Samples
eyeYRx=zeros(N_BAUDS*UP,N_TRACES);
eyeYTx=zeros(N_BAUDS*UP,N_TRACES);
// Baud samples
eyeSRx=zeros(N_BAUDS*UP,N_TRACES);
eyeSTx=zeros(N_BAUDS*UP,N_TRACES);
// wrapped time
eyeT=(1:N_BAUDS*UP)'*ones(1,N_TRACES);
eyeStyleY=2*ones(1,N_TRACES);
eyeStyleS=5*ones(1,N_TRACES);

// eye CIRCBUFF  
p_eyeRx = SCI_CREATE(SCI_CIRCBUFF);
SCI_SET(p_eyeRx, SCI_SIZE, N_EYE);
p_eyeSampRx = SCI_CREATE(SCI_CIRCBUFF);
SCI_SET(p_eyeSampRx, SCI_SIZE, N_EYE);

p_eyeTx = SCI_CREATE(SCI_CIRCBUFF);
SCI_SET(p_eyeTx, SCI_SIZE, N_EYE);
p_eyeSampTx = SCI_CREATE(SCI_CIRCBUFF);
SCI_SET(p_eyeSampTx, SCI_SIZE, N_EYE);

// if variable does not exist it is initialized as empty matrix
// so you must first create it and then make it global
// do not use , as separator in global !    
global MOD M UP TxDev RxDev N_FFT RMS_MAV N_FFT N_GCB BERT W;
// prbs source
global p_prbs1;
global p_b2i1;
global p_i2b1, p_i2b2;
global p_mod1;
global p_dem1;
global p_cnt1;
global p_fir_rx1 p_fir_rx2;
global p_fir_tx1;
global p_firdel1 p_firdel2 p_firdel3 p_firdel4 p_firdel5 p_firdel6 ;
global p_amp1 p_amp2 p_amp3 p_amp4;
global p_nco1;
global p_ejp1;
global p_wgn_x1;
global p_iq2ap1;
global p_rms_x1 p_rms_x2 p_rms_x3 p_rms4, p_rms5;
global p_bert1; 
// FFT CIRCBUFF_X  
global p_fft_x1 p_fft_x2 p_fft_x3 p_fft_x4 ;
// Create structs to keep FFT data 
global s_sp1 s_sp2 s_sp3 s_sp4; 
// eye diagrams
global N_BAUDS N_TRACES N_EYE;
global eyeYRx eyeYTx eyeSRx eyeSTx;
// wrapped time
global eyeT eyeStyleY eyeStyleS;
// circ_buffers
global p_eyeRx p_eyeSampRx p_eyeTx p_eyeSampTx;
// BER counter
global BER ber; 
