function SimApp()
// global params
global MOD M UP TxDev RxDev N_FFT RMS_MAV N_FFT N_GCB BERT W;
// handlers
global p_prbs1;	
global p_b2i1;
global p_i2b1, p_i2b2;
global p_mod1;
global p_dem1;
global p_cnt1;
global p_fir_rx1 p_fir_rx2;
global p_fir_tx1;
global p_firdel1 p_firdel2 p_firdel3 p_firdel4 p_firdel5 p_firdel6 ;
global p_amp1 p_amp2 p_amp3 p_amp4;
global p_nco1;
global p_ejp1;
global p_wgn_x1;
global p_iq2ap1;
global p_rms_x1 p_rms_x2 p_rms_x3 p_rms4, p_rms5;
global p_bert1; 
global p_fft_x1 p_fft_x2 p_fft_x3 p_fft_x4 ;
global p_eyeRx p_eyeSampRx p_eyeTx p_eyeSampTx;
// options
global N_opt1 N_opt2 N; 
global button_state1 button_state2;
global BER ber; 
global BERT_LOCK_FLAG AWGN_FLAG BERT_CLEAR_FLAG;
global C_N C_N_set;
global RMS1 RMS2 RMS3 RMS4 RMS5;
global Figopt1 Figopt2 Figopt3 Figopt4;
global Figmenu1 Figmenu2 Figmenu3 Figmenu4;
global fftwintype Nfft FFT_RESET_FLAG;
global REF_FFT REF_dB RANGE_dB FFT_LOG;
// display 
global s_sp1 s_sp2 s_sp3 s_sp4;
global N_BAUDS N_TRACES N_EYE;
global eyeYRx eyeYTx eyeSRx eyeSTx;
global eyeT eyeStyleY eyeStyleS;

global fD phID fModDel phMod phd;             
global sTxDel sRx iTxDel iRx; 
global ceTxD ceTx ceRx;
global cTx;
// initialized variables
global ph0 ip0;
// static - must be preserved outside scope of function  
global winfft BER_bert BER_xor;

    ce=(ones(N,1)==1);
    n_ce=(ones(N,1)==0);

    // C_NdB=20*log(C_rms/N_rms)
    // N_rms^2=UP*N^2
    N_rms = (C_rms/ 10^(C_N/20));
    SCI_SET(p_wgn_x1, SCI_SIGMA, N_rms);
    if ( AWGN_FLAG )
      nIQ = SCI_GEN(p_wgn_x1, ce);
    else
      nIQ = zeros(N,1)+%i*zeros(N,1);
    end  

    ceTx=SCI_GEN(p_cnt1,ce);
    // signal 
    bTx = SCI_GEN(p_prbs1, ceTx);	
    iTx = SCI_PROC(p_b2i1, ceTx, bTx);      
    sTx = SCI_PROC(p_mod1, ceTx, iTx);
    cex=[ceTx, ce]; 
    sTxUS = SCI_PROC(p_fir_tx1, cex, sTx);        
    sUp=sTxUS*TxG;
    fMod = SCI_PROC(p_amp1, ce, sUp);
    // FM Modulation
    cy_ph_Tx = SCI_PROC(p_nco1, ce, fMod);       
    phMod=cy_ph_Tx(:,2);
    cTx = SCI_PROC(p_ejp1, ce, phMod);
    
    // measure signal
    cRMS = SCI_PROC(p_rms_x1, ce, cTx);       
    RMS1= mean(cRMS);
    // measure noise
    nRMS = SCI_PROC(p_rms_x2, ce, nIQ);
    RMS2= mean(nRMS);
    // measure noise in channel BW to get noise BW
    nRx = SCI_PROC(p_fir_rx2, ce, nIQ);
    nFRMS = SCI_PROC(p_rms_x3, ce, nRx);
    RMS3= mean(nFRMS);

    // Channel
    cRx = cTx + nIQ;
    // perfect timing recovery and reference generation
    ceTxD = to_bvec(SCI_PROC(p_firdel1, ce, to_vec(ceTx)));
    ceRx = to_bvec(SCI_PROC(p_firdel2, ce, to_vec(ceTxD)));
    // symbol signals
    sTxDel=SCI_PROC(p_firdel3, ce, sTx);
    iTxDel=SCI_PROC(p_firdel4, ce, double(iTx));
    fModDel=SCI_PROC(p_firdel6, ce, fMod);
    // filter
    cFx = SCI_PROC(p_fir_rx1, ce, cRx);
    // Cartesian demodulation
    a_ph_d = SCI_PROC(p_iq2ap1, ce, cFx);
    phd = a_ph_d(:,2)/(2*%pi);
    aD = a_ph_d(:,1);
    fD=DiffPhase(phd,ph0);
    ph0 = phd($);
            
    // integrate fD to get phase
    phInt=IntegratePhase(fD, ip0, ce, ceTxD);
    ip0=phInt($);
    // delay by 1 to slicer
    phID=SCI_PROC(p_firdel5, ce, phInt);


    // slicer FSX - sample fD at baud center
    // FSK integrate fD and dump
    // MSK phase normalized to +/-0.5
    if (MOD == "xFSK")             
      sRx = SCI_PROC(p_amp2, ceRx, fD);            
    elseif (MOD == "FSK")
      sRx = SCI_PROC(p_amp3, ceTxD, phID); // phID=avg(fD*UP) 
      // iRx = SCI_PROC(p_dem1, ceTxD, sRx);
    elseif (MOD == "MSK")
      sRx = SCI_PROC(p_amp4, ceTxD, phID); // +/-0.25 of normalized phase -> +/-0.5 
      // iRx = SCI_PROC(p_dem1, ceTxD, sRx);           
    else
    
    end
         
    iRx = SCI_PROC(p_dem1, ceRx, sRx); // sample in the central bin                    
    // symbol to bit
    bRx = SCI_PROC(p_i2b1, ceRx, iRx);      
    bTxDel = SCI_PROC(p_i2b1, ceRx, iTxDel);
    // input data to BERT - observe state
    bert_state = double(SCI_PROC(p_bert1, ceRx, bRx));
    // instantenous  [bit_e,bit_cnt]
    ber_bert = SCI_GET(p_bert1, SCI_CNT);
    // accumulated [BIT_ERR, BIT_CNT]
    BER_bert = SCI_GET(p_bert1, SCI_ACC_CNT);	         
    bRxSamp = ReSamp(ceRx,bRx);
    bTxSamp = ReSamp(ceRx,bTxDel);
    vRx=to_vec(rvectorize(bRxSamp));
    vTx=to_vec(rvectorize(bTxSamp));
    [biterr, bitnum] = HammingDist(vRx,vTx);
    ber_xor = [biterr, bitnum];
    BER_xor = BER_xor + ber_xor;

    if (BERT == 1)
      // lock if state is not lower than [BERT_FSM_SYNC, BERT_FSM_nSYNC] 
      BERT_LOCK_FLAG = and( (bert_state >= BERT_FSM_nSYNC));
      if (~ BERT_LOCK_FLAG) then
        printf(" BERT_UNLOCK\n");
      end  
      ber = ber_bert;
      BER = BER_bert;
    else
      BERT_LOCK_FLAG = %T;
      ber = ber_xor;
      BER = BER_xor;        
    end    
    
    // measure MER
    eRx = sTxDel - sRx;
    // sample error only when sliced
    // since samples are replicated for ce=0 you can avarage output        
    RMS4 = mean(SCI_PROC(p_rms4, ceRx, sTxDel )); 
    RMS5 = mean(SCI_PROC(p_rms5, ceRx, eRx )); 

    // spectrum analysis - constant parameters
    // FFT_RESET_FLAG is set when parameters are changed
    if (FFT_RESET_FLAG == 1)           
      select fftwintype
        case "rect" then winfft=window('re',Nfft);    // Recatangular
        case "tria" then winfft=window('tr',Nfft);    // triangular
        case "hamm" then winfft=window('hm',Nfft);    // Hamming window
        case "hann" then winfft=window('hn',Nfft);     // Hanning window
        case "kais" then winfft=window('kr',Nfft,8.6); // Kaisser with alpha=8.6
        else             winfft=window('hm',Nfft);
      end; 
      // this is folded freq 
      ff = (-Nfft/2:1:(Nfft/2)-1)./Nfft;
      // reset spectrum - set folded spectrum according to ZOOM and center frequency
      s_sp1 = reset_spec(s_sp1, Nfft, ff, 0.0, 0);
      s_sp2 = reset_spec(s_sp2, Nfft, ff, 0.0, 0);
      s_sp3 = reset_spec(s_sp3, Nfft, ff, 0.0, 0);
      s_sp4 = reset_spec(s_sp4, Nfft, ff, 0.0, 0);
      FFT_RESET_FLAG = 0; 
    end   

    // data for spectral analysis must be collected with ceo == 0 
    SCI_PROC(p_fft_x1, [ce,n_ce], cTx );
    SCI_PROC(p_fft_x2, [ce,n_ce], cRx );
    SCI_PROC(p_fft_x3, [ce,n_ce], cFx );
    SCI_PROC(p_fft_x4, [ce,n_ce], nRx );
    
    // data for Rx eye analysis  
    SCI_PROC(p_eyeRx, [ce,n_ce], fD*RxDev );
    SCI_PROC(p_eyeSampRx, [ce,n_ce], 0.3*to_vec(ceRx)+0.15*to_vec(ceTxD)+0.1*to_vec(ce) );
    
    if (SCI_GET(p_eyeRx, SCI_N_OF_ELEM) == N_EYE)
      eyeDataRx = SCI_GET(p_eyeRx, SCI_VEC);
      eyeSampRx = SCI_GET(p_eyeSampRx, SCI_VEC);
      // resize each column is one plot
      eyeYRx=matrix(eyeDataRx,N_BAUDS*UP,N_TRACES);
      eyeSRx=matrix(eyeSampRx,N_BAUDS*UP,N_TRACES);
    end

    // data for Tx eye analysis  
    SCI_PROC(p_eyeTx, [ce,n_ce], sUp );
    SCI_PROC(p_eyeSampTx, [ce,n_ce], 0.15*to_vec(ceTx)+0.1*to_vec(ce) );
    
    if (SCI_GET(p_eyeTx, SCI_N_OF_ELEM) == N_EYE)
      eyeDataTx = SCI_GET(p_eyeTx, SCI_VEC);
      eyeSampTx = SCI_GET(p_eyeSampTx, SCI_VEC);
      // resize each column is one plot
      eyeYTx=matrix(eyeDataTx,N_BAUDS*UP,N_TRACES);
      eyeSTx=matrix(eyeSampTx,N_BAUDS*UP,N_TRACES);
    end
        
endfunction
