function Update_TCLTK()

global N_opt1 N_opt2 N; 
global button_state1 button_state2;
global BER ber; 
global BERT_LOCK_FLAG AWGN_FLAG BERT_CLEAR_FLAG BERT BERT_XOR_FLAG;
global C_N C_N_set;
global RMS1 RMS2 RMS3 RMS4 RMS5;
global Figopt1 Figopt2 Figopt3 Figopt4;
global Figmenu1 Figmenu2 Figmenu3 Figmenu4;
global fftwintype Nfft fftwintypeX NfftX FFT_RESET_FLAG;
global REF_FFT REF_dB RANGE_dB FFT_LOG;

 //----------- main ----------------

 button_state2=TCL_GetVar('button_state');
  if (button_state2<>button_state1)
    button_state1=button_state2;
  end


  N_opt2 = TCL_GetVar("Nopt");
  if (N_opt2<>N_opt1)
    N_opt1 = N_opt2;
    N=floor(msscanf(N_opt1,"%d"));
  end;

// ------- C/N ----------------------

  C_N = msscanf(TCL_GetVar("C_N"),"%f");
  AWGN_FLAG = msscanf(TCL_GetVar("AWGN_flag"),"%d");

// ------- RMS ----------------------

  TCL_SetVar("RMS1", sprintf("%f",RMS1));
  TCL_SetVar("RMS2", sprintf("%f",RMS2));
  TCL_SetVar("RMS3", sprintf("%f",RMS3)); 
  if (RMS2 > 0.0) 
    NBW= (RMS3*RMS3)/(RMS2*RMS2);
  else
    NBW=1.0;
  end
  TCL_SetVar("NBW", sprintf("%2.2f",NBW));

  if (RMS3 > 0.0) 
    SNR= 20*log10(RMS1/RMS3);
  else
    SNR=100.0;
  end
  TCL_SetVar("SNR", sprintf("%2.2f",SNR));

// ------- MER ----------------------  
  TCL_SetVar("S_rms1", sprintf("%f",RMS4));
  TCL_SetVar("E_rms1", sprintf("%f",RMS5));
  if (RMS5 > 0.0) 
    MER1= 20*log10(RMS4/RMS5);
  else
    MER1=100.0;
  end
  TCL_SetVar("MER1", sprintf("%2.2f",MER1));


// ------- BER ----------------------
  TCL_SetVar("e1", sprintf("%d",ber(1)));
  TCL_SetVar("cnt1", sprintf("%d",ber(2)));
  if (ber(2) > 0) 
    ber1=double( ber(1))/double(ber(2));
  else
    ber1=0.0 ; 
  end
  TCL_SetVar("ber1", sprintf("%1.1E",ber1));

  TCL_SetVar("E1", sprintf("%d",BER(1)));
  TCL_SetVar("CNT1", sprintf("%d",BER(2)));
  if (BER(2) > 0) 
    BER1= double(BER(1))/double(BER(2));
   else
    BER1=0.0;  
  end
  TCL_SetVar("BER1", sprintf("%1.1E",BER1));

  TCL_EvalStr('set h3 [winfo exists .ber1]');
  if ~(TCL_GetVar('h3')=='0') then 
    if (BERT_LOCK_FLAG)
      TCL_SetVar("BERTLockFlag",1);
    else
      TCL_SetVar("BERTLockFlag",0);
    end 
    TCL_EvalStr("showBERTLockFlag");     
    BERT_CLEAR_FLAG = (msscanf(TCL_GetVar("BERTClearFlag"),"%d")==1);
    if ( BERT_CLEAR_FLAG ) then
      TCL_SetVar("BERTClearFlag",0);
    end
    BERT_XOR_FLAG = msscanf(TCL_GetVar("BERTXorFlag"),"%d");
    if ( pmodulo(BERT+BERT_XOR_FLAG,2)==0 )          // BERT should be XOR inversion
      BERT = pmodulo(BERT_XOR_FLAG+1,2);              // invert by xoring with 1
      printf("BERT = %d \n",BERT); 
    end 
  end

  // refresh fig options
  Figopt1 = TCL_GetVar('Figopt1');
  Figopt2 = TCL_GetVar('Figopt2');
  Figopt3 = TCL_GetVar('Figopt3');
  Figopt4 = TCL_GetVar('Figopt4');  
  Figmenu1 = TCL_GetVar('Figmenu1');
  Figmenu2 = TCL_GetVar('Figmenu2');
  Figmenu3 = TCL_GetVar('Figmenu3');
  Figmenu4 = TCL_GetVar('Figmenu4');

  // refresh FFT options
  fftwintypeX = TCL_GetVar('fftwintype');
  NfftX = msscanf(TCL_GetVar('Nfft'),"%d");
  // if change force reset of buffers and avg  
  if ( fftwintypeX <> fftwintype)
    fftwintype = fftwintypeX;
    FFT_RESET_FLAG = 1;
  end;
  // if change force reset of buffers and avg
  if ( NfftX <> Nfft)
    Nfft = NfftX;
    FFT_RESET_FLAG = 1;
  end;
  
  REF_FFT = msscanf(TCL_GetVar("REF_FFT"),"%f");
  REF_dB= msscanf(TCL_GetVar("REF_dB"),"%f");
  RANGE_dB = msscanf(TCL_GetVar("RANGE_dB"),"%f");
  FFT_LOG = msscanf(TCL_GetVar("FFT_LOG"),"%d");

endfunction

function csim_tcl_win_destroy()
// Destroy the toplevel widgets
  TCL_EvalStr("catch { destroy .app4 }");
  TCL_EvalStr("catch { destroy .fig1 }"); 
  TCL_EvalStr("catch { destroy .cn1 }");
  TCL_EvalStr("catch { destroy .ber1 }");
  TCL_EvalStr("catch { destroy .rms1 }");
  TCL_EvalStr("catch { destroy .mer1 }");
  TCL_EvalStr("catch { destroy .fft1 }");
endfunction


// Try to invoke Main TCL script in the novel way:
//-----------------------------------------------
// set variables first
//-----------------------------------------------
// and then run script
//-----------------------------------------------


//-----------------------------------------------
// set variables first
//-----------------------------------------------

TCL_SetVar("AWGN_flag", AWGN_FLAG);
TCL_SetVar("C_Nmin", C_N_set(1));
TCL_SetVar("C_Nmax", C_N_set(2));
TCL_SetVar("C_N0", C_N_set(3));
// RMS
TCL_SetVar("RMS1", 0.0);
TCL_SetVar("RMS2", 0.0);
TCL_SetVar("RMS3", 0.0);
TCL_SetVar("SNR", 100.0);
TCL_SetVar("NBW", 1.0);
// MER
TCL_SetVar("S_rms", 0.0);
TCL_SetVar("E_rms", 0.0);
TCL_SetVar("MER1", 100.0);

// BER
TCL_SetVar("e1", 0.0);
TCL_SetVar("cnt1", 0.0);
TCL_SetVar("ber1", 0.0);
TCL_SetVar("E1", 0.0);
TCL_SetVar("CNT1", 0.0);
TCL_SetVar("BER1", 0.0);
TCL_SetVar("BERTLockFlag", 0);
TCL_SetVar("BERTClearFlag", 0);
BERT_XOR_FLAG = pmodulo(BERT+1,2); // BERT_XOR_FLAG=not(BERT) 
TCL_SetVar("BERTXorFlag", BERT_XOR_FLAG);

// graphics - set menu options
// fig1
TCL_SetVar("Fig1menu1", "fft(CFx)");
TCL_SetVar("Fig1menu2", "fft(CRx)");
TCL_SetVar("Fig1menu3", "fft(CTx)");
TCL_SetVar("Fig1menu4", "fft(nRx)");

// fig2
TCL_SetVar("Fig2menu1", "fD*RxDev|sRx");
TCL_SetVar("Fig2menu2", "phID|phd");
TCL_SetVar("Fig2menu3", "Rx Eye");
TCL_SetVar("Fig2menu4", "phMod|phd");
// fig3
TCL_SetVar("Fig3menu1", "Rx Eye");
TCL_SetVar("Fig3menu2", "fft(CRx)");
TCL_SetVar("Fig3menu3", "fft(CTx)");
TCL_SetVar("Fig3menu4", "real(cTx)|imag(cTx)");
// fig4
TCL_SetVar("Fig4menu1", "sTx|sTxDel+sRx");
TCL_SetVar("Fig4menu2", "sRx|phID");
TCL_SetVar("Fig4menu3", "sRx+phInt|iRx+iTxDel");
TCL_SetVar("Fig4menu4", "Tx Eye");

// init variables by read back
TCL_SetVar("Figopt1", "opt1");
TCL_SetVar("Figmenu1",  TCL_GetVar('Fig1menu1'));
TCL_SetVar("Figopt2", "opt1");
TCL_SetVar("Figmenu2", TCL_GetVar('Fig2menu1'));
TCL_SetVar("Figopt3", "opt1");
TCL_SetVar("Figmenu3", TCL_GetVar('Fig3menu1'));
TCL_SetVar("Figopt4", "opt1");
TCL_SetVar("Figmenu4", TCL_GetVar('Fig4menu1'));
// fft
TCL_SetVar("fftwintype", 'kais');
TCL_SetVar("Nfft", sprintf("%d",N_FFT)); // force decimal not float
// set variables to ensure avg=0 when change
fftwintype = TCL_GetVar('fftwintype');
Nfft = msscanf(TCL_GetVar('Nfft'),"%d");
// plot FFT options
TCL_SetVar("REF_FFT", 1.0);
TCL_SetVar("REF_dB", +0.0);
TCL_SetVar("RANGE_dB", 100.0);
TCL_SetVar("FFT_LOG", sprintf("%d",1)); // force decimal not float

//-----------------------------------------------
// and then run script
//-----------------------------------------------

TCL_EvalFile("..\tcl\tk_app04_v1.tcl");


