//! FSK/MSK modem

clear;
clearglobal;
clc;
lines(0);
path=get_absolute_file_path("mi.sce");
chdir(path);

// Fig 1,2,4
xdel(winsid());

// constelation SIZE of PAM modulator
M = 4;
// upsampling
UP = 8;
// shaper gain is normalized in app04 
// TxG = 1;
// modulation index
mi=0.15

//---------------------------

select M
case 2 
    a=0.5;
case 4 
    a=0.25;
case 8 
    a=0.125;
end

// input of DSS is a frequency normalized to sampling Fs  
// devF=dev/Fs
// dev/(UP*SR)=TxDev*a*TxG
// dev/SR=UP*TxDev*a*TxG
// mi=2*dev/SR=2*UP*TxDev*a*TxG
TxDev = mi/UP/2/a
devF=TxDev*a

// Rx FM demodulator gives devF=dev/Fs
// this is multipled by RxDev to give inner symbol which corresponds to miTx 
// devF*RxDev = a
RxDev = a/devF




    
    

