//! FSK/MSK modem

clear;
clearglobal;
clc;
lines(0);
path=get_absolute_file_path("mod.sce")
chdir(path);
pwd

// Fig 1,2,4
xdel(winsid());

// GetConfig
exec("..\sci_tk_getcfg_v1.sci");
exec(".\app04ModFunc.sci");
confFilename = csim_tkgetconfig(".\conf\conf_def.cfg",".\conf")
[simConf,err] = loadconfig(confFilename);
disp(simConf);


// constelation SIZE of PAM modulator
MOD = simConf.MOD;
M = simConf.M;
UP = simConf.UP;
FIR_TX = simConf.FIR_TX;
FIR_RX = simConf.FIR_RX;
TxDev = simConf.TxDev;
RxDev = simConf.RxDev;
// size of PRBS generator
PRBS = simConf.PRBS;
// C_NdB for wgn_x
C_N_set=simConf.C_N_set
// MAV for RMS estimator
RMS_MAV=simConf.RMS_MAV;
// size of FFT for spectral analysis
N_FFT = simConf.N_FFT;
// size of graphic circulat buff for eye
N_GCB = simConf.N_GCB;

// word lenght    
W = ceil(log2(M));
// calc Tx modulation index
// value of inner symbol
select M
case 2 
    a=0.5;
case 4 
    a=0.25;
case 8 
    a=0.125;
end
// gain of shaper is always normalized by app04 
// input of DSS is a frequency normalized to sampling Fs  devF=dev/Fs 
devF=TxDev*a
// Fs=SR*UP 
// mi=2*dev/SR=
miTx=2*devF*UP
// Rx FM demodulator gives devF=dev/Fs
// this is multipled by RxDev to give inner symbol which corresponds to miTx 
miRx=devF*(RxDev/a)*miTx

    
    

