# Scilab sets variables and then runs the script

if {! [info exist dbg_mode ]} {
    set sci_mode [llength [info commands ScilabEval]]
    set dbg_mode [expr ! $sci_mode ]
}

# ------------------------------------------------------
# variables for debug - standalone mode

if {$dbg_mode} {
console show
# this must be set by scilab
set e1   1
set cnt1 256
set ber1 [format "%1.1E" [expr (double($e1)/double($cnt1))]]
set E1 10
set CNT1 2560
set BER1 [format "%1.1E" [expr (double($E1)/double($CNT1))]]
set BERTLockFlag 0
set BERTClearFlag 0
set BERTXorFlag 0
}

# scilab needs a toplevel for this package to operate properly!!!

# set win .w3
catch {destroy .ber1}
toplevel .ber1

proc showBERTLockFlag {} {
    global BERTLockFlag
    uplevel {
    if ($BERTLockFlag) {
        .ber1.frame0.lockbt configure -background green
    } else {
        .ber1.frame0.lockbt configure -background red
    }
    # puts "BERTLockFlag=$BERTLockFlag"
    }
}

proc setBERTClearFlag {} {
    global BERTClearFlag

    set BERTClearFlag  1
    puts "BERTClearFlag=$BERTClearFlag"
}


#------------ frame 0


    frame .ber1.frame0  -borderwidth 15
    label .ber1.frame0.lockbt -text "BERT Lock"
    button .ber1.frame0.b1 -text "BERT CLEAR"  -command { setBERTClearFlag  } -width 10

    checkbutton .ber1.frame0.cb0 -text "XOR"\
        -variable BERTXorFlag -onvalue 1 -offvalue 0 -command  { puts "BERTXorFlag=$BERTXorFlag" }


    pack .ber1.frame0 -side left
    pack .ber1.frame0.cb0
    pack .ber1.frame0.lockbt
    pack .ber1.frame0.b1  -pady 10

    showBERTLockFlag




#------------ frame 1
    frame .ber1.frame1 -borderwidth 1

    labelframe .ber1.frame1.l1 -text {e1}
    entry .ber1.frame1.l1.e -relief sunken -width 15 -textvariable e1
    pack .ber1.frame1.l1.e -fill x -expand 1 -padx 1 -pady 1

    labelframe .ber1.frame1.l2 -text {cnt1}
    entry .ber1.frame1.l2.e -relief sunken -width 15 -textvariable cnt1
    pack .ber1.frame1.l2.e -fill x -expand 1 -padx 1 -pady 1

    labelframe .ber1.frame1.l3 -text {ber1=e1/cnt1}
    entry .ber1.frame1.l3.e -relief sunken -width 15 -textvariable ber1
    pack .ber1.frame1.l3.e -fill x -expand 1 -padx 1 -pady 1


#------------ frame 2
    frame .ber1.frame2 -borderwidth 1

    labelframe .ber1.frame2.l1 -text {E1}
    entry .ber1.frame2.l1.e -relief sunken -width 15 -textvariable E1
    pack .ber1.frame2.l1.e -fill x -expand 1 -padx 1 -pady 1

    labelframe .ber1.frame2.l2 -text {CNT1}
    entry .ber1.frame2.l2.e -relief sunken -width 15 -textvariable CNT1
    pack .ber1.frame2.l2.e -fill x -expand 1 -padx 1 -pady 1

    labelframe .ber1.frame2.l3 -text {BER1=E1/CNT1}
    entry .ber1.frame2.l3.e -relief sunken -width 15 -textvariable BER1
    pack .ber1.frame2.l3.e -fill x -expand 1 -padx 1 -pady 1

    pack  .ber1.frame1 -side left
    pack  .ber1.frame2 -side left

    pack .ber1.frame1.l1 .ber1.frame1.l2 .ber1.frame1.l3 -padx 3  -pady 1
    pack .ber1.frame2.l1 .ber1.frame2.l2 .ber1.frame2.l3 -padx 3  -pady 1



