# Scilab sets variables and then runs the script

if {! [info exist dbg_mode ]} {
    set sci_mode [llength [info commands ScilabEval]]
    set dbg_mode [expr ! $sci_mode ]
}

# ------------------------------------------------------
# variables for debug - standalone mode

if {$dbg_mode} {
# this must be set by scilab
set C_rms1 0.111111
set N_rms1 0.002222
set C_N1 [format "%2.1f" [expr 20*log($C_rms1/$N_rms1)]]
}

# scilab needs a toplevel for this package to operate properly!!!

set win .w4
catch {destroy $win}
toplevel $win


#------------ frame 1
    frame $win.frame1 -borderwidth 1
    pack  $win.frame1 -side left

    labelframe $win.frame1.l1 -text {C_rms1}
    entry $win.frame1.l1.e -relief sunken -width 15 -textvariable C_rms1
    pack $win.frame1.l1.e -fill x -expand 1 -padx 1 -pady 1

    labelframe $win.frame1.l2 -text {N_rms1}
    entry $win.frame1.l2.e -relief sunken -width 15 -textvariable N_rms1
    pack $win.frame1.l2.e -fill x -expand 1 -padx 1 -pady 1

    labelframe $win.frame1.l3 -text {C_N1=20lg(C/N)}
    entry $win.frame1.l3.e -relief sunken -width 15 -textvariable C_N1
    pack $win.frame1.l3.e -fill x -expand 1 -padx 1 -pady 1

    pack $win.frame1.l1 $win.frame1.l2 $win.frame1.l3 -padx 3  -pady 1

