# Scilab sets variables and then runs the script

if {! [info exist dbg_mode ]} {
    set sci_mode [llength [info commands ScilabEval]]
    set dbg_mode [expr ! $sci_mode ]
}

# ------------------------------------------------------
# variables for debug - standalone mode

if {$dbg_mode} {
# this must be set by scilab
set S_rms1 0.111111
set E_rms1 0.002222
set MER1 [format "%2.1f" [expr 20*log($S_rms1/$E_rms1)]]
}

# scilab needs a toplevel for this package to operate properly!!!

set win3 .w5
catch {destroy $win3}
toplevel $win3


#------------ frame 1
    frame $win3.frame1 -borderwidth 1
    pack  $win3.frame1 -side left

    labelframe $win3.frame1.l1 -text {S_rms1}
    entry $win3.frame1.l1.e -relief sunken -width 15 -textvariable S_rms1
    pack $win3.frame1.l1.e -fill x -expand 1 -padx 1 -pady 1

    labelframe $win3.frame1.l2 -text {E_rms1}
    entry $win3.frame1.l2.e -relief sunken -width 15 -textvariable E_rms1
    pack $win3.frame1.l2.e -fill x -expand 1 -padx 1 -pady 1

    labelframe $win3.frame1.l3 -text {MER1=20lg(S/E)}
    entry $win3.frame1.l3.e -relief sunken -width 15 -textvariable MER1
    pack $win3.frame1.l3.e -fill x -expand 1 -padx 1 -pady 1

    pack $win3.frame1.l1 $win3.frame1.l2 $win3.frame1.l3 -padx 3  -pady 1

