# Scilab sets variables and then runs the script

if {! [info exist dbg_mode ]} {
    set sci_mode [llength [info commands ScilabEval]]
    set dbg_mode [expr ! $sci_mode ]
}

# ------------------------------------------------------
# variables for debug - standalone mode

if {$dbg_mode} {
# this must be set by scilab
set Carrier2 0.111111
set Error2 0.002222
set MER2 [format "%2.5E" [expr 20*log($Carrier2/$Error2)]]
}

# scilab needs a toplevel for this package to operate properly!!!

set win4 .w4
catch {destroy $win4}
toplevel $win4


#------------ frame 1
    frame $win4.frame1 -borderwidth 1 
    pack  $win4.frame1 -side left

    labelframe $win4.frame1.l1 -text {Carrier2}
    entry $win4.frame1.l1.e -relief sunken -width 15 -textvariable Carrier2
    pack $win4.frame1.l1.e -fill x -expand 1 -padx 1 -pady 1

    labelframe $win4.frame1.l2 -text {Error2}
    entry $win4.frame1.l2.e -relief sunken -width 15 -textvariable Error2
    pack $win4.frame1.l2.e -fill x -expand 1 -padx 1 -pady 1

    labelframe $win4.frame1.l3 -text {MER2=20lg(C2/E2)}
    entry $win4.frame1.l3.e -relief sunken -width 15 -textvariable MER2
    pack $win4.frame1.l3.e -fill x -expand 1 -padx 1 -pady 1

    pack $win4.frame1.l1 $win4.frame1.l2 $win4.frame1.l3 -padx 3  -pady 1

