# Scilab sets variables and then runs the script

if {! [info exist dbg_mode ]} {
    set sci_mode [llength [info commands ScilabEval]]
    set dbg_mode [expr ! $sci_mode ]
}

# ------------------------------------------------------
# variables for debug - standalone mode

if {$dbg_mode} {
# this must be set by scilab
console show

set S_rms1 0.111111
set E_rms1 0.002222
set MER1 [format "%2.1f" [expr 20*log($S_rms1/$E_rms1)]]

}

# scilab needs a toplevel for this package to operate properly!!!

# set win3 .w4
catch {destroy .mer1}
toplevel .mer1


#------------ frame 1
    frame .mer1.frame1 -borderwidth 1

    labelframe .mer1.frame1.l1 -text {S_rms1}
    entry .mer1.frame1.l1.e -relief sunken -width 15 -textvariable S_rms1
    pack .mer1.frame1.l1.e -fill x -expand 1 -padx 1 -pady 1

    labelframe .mer1.frame1.l2 -text {E_rms1}
    entry .mer1.frame1.l2.e -relief sunken -width 15 -textvariable E_rms1
    pack .mer1.frame1.l2.e -fill x -expand 1 -padx 1 -pady 1

    labelframe .mer1.frame1.l3 -text {MER1=20lg(S/E)}
    entry .mer1.frame1.l3.e -relief sunken -width 15 -textvariable MER1
    pack .mer1.frame1.l3.e -fill x -expand 1 -padx 1 -pady 1


    pack  .mer1.frame1 -side left

    pack .mer1.frame1.l1 .mer1.frame1.l2 .mer1.frame1.l3 -padx 3  -pady 1

